package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.desktoppricecoef;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusbssynced;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки параметра DesktopPriceCoef на уровне кампании, удаление")
@Stories(StoriesNames.CAMPAIGN_PARAMS_DESKTOPPRICECOEF)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-86815")
public class BsTransportOfCampaignDesktopPriceCoefDeleteTest {

    private static final Short DESKTOP_PRICE_COEF = 50;
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);
    private static DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
    private static int shard;

    private Campaign campaign;
    private RunBsTransportScriptResponse resp;
    private Long cid;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void before() {
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        jooqDbSteps.multipliersSteps().saveCampaignDesktopMultiplier(cid, DESKTOP_PRICE_COEF);

        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("отправленная в БК корректировка DesktopPriceCoef на уровне кампании соответствует ожидаемой",
                campaign.getDesktopPriceCoef(), equalTo(DESKTOP_PRICE_COEF.toString()));

        jooqDbSteps.multipliersSteps().deleteAllMultipliers(cid);
        jooqDbSteps.campaignsSteps().setCampaignsStatusBsSynced(cid, CampaignsStatusbssynced.No);

        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
    }

    @Test
    @Title("Отправка в БК корректировки DesktopPriceCoef со значением undef на уровне кампании после ее удаления")
    public void testTransportOfCampaignDesktopPriceCoef() {
        assertThat("в БК отправлена корректировка DesktopPriceCoef со значение undef на уровне кампании",
                helpSteps.getOrderMap(resp, cid).get(Campaign.DESKTOP_PRICE_COEF), equalTo(null));
    }
}
