package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.domainmonitoring;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSettingMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pashkus on 24.06.16.
 * https://st.yandex-team.ru/TESTIRT-9372
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-53323")
@Title("Проверяем отправку параметра ORDER.CheckBannersAvailability для мониторинга БК")
@Description("Предполагаем, что значение мониторинга БК (ppcdict.url_availability_bs_usage_pct = 50%" +
        "что означает что используемые в тесте пользователи будут соответствовать нужному классу эквивалентности")
@Features(FeatureNames.CAMPAIGNS)
@Stories(StoriesNames.CAMPAIGN_PARAMS_DOMAIN_MONITORING)
@RunWith(Parameterized.class)
public class CheckUrlAvailabilityActivityTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Campaign campaign;

    @Parameterized.Parameter()
    public String login;

    @Parameterized.Parameter(1)
    public YesNoEnum enableSiteMonitoring;

    @Parameterized.Parameter(2)
    public Integer checkBannersAvailability;


    @Parameterized.Parameters(name = "В Директе enableSiteMonitoring = {2}; " +
            "ожидаем в транспорте CheckBannersAvailability = {3}; " +
            "login = {0}; предполагаем, что пользователь под мониторингом БК: {1};")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {Logins.LOGIN_TRANSPORT, YesNoEnum.YES, 1},
                {Logins.LOGIN_TRANSPORT, YesNoEnum.NO, 0}
        };
        return Arrays.asList(data);
    }


    @Before
    @Step("Создаем кампанию с вкл/выкл мониторингом доменов для клиента под мониторингом БК/Метрики")
    public void beforeClass() {
        api.as(login);
        int shard = api.userSteps.clientFakeSteps().getUserShard(login);

        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap()
                        .defaultTextCampaign()
                        .withSettings(new TextCampaignSettingMap()
                                .withOption(TextCampaignSettingsEnum.ENABLE_SITE_MONITORING)
                                .withValue(enableSiteMonitoring))));

        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        RunBsTransportScriptResponse resp
                = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);

    }

    @Test
    @Title("Проверяем отправку поля CheckBannersAvailability (если клиент под мониторингом БК)")
    public void testOfCheckBannersAvailabilty() {
        assertThat("на уровне ORDER отправляем CheckBannersAvailability = " + checkBannersAvailability,
                campaign.getCheckBannersAvailability(),
                equalTo(checkBannersAvailability));
    }

    @Test
    @Title("Проверяем неотправку в БК IgnoreTimeLimit")
    @Description("Ожидаем отсутствие поля в транспорте БК")
    public void testOfIgnoreTimeLimitSending() {

        assumeThat("ORDER.UpdateInfo = 1", campaign.getUpdateInfo(), equalTo(1));

        assertThat("на уровне ORDER не отправляем IgnoreTimeLimit",
                campaign.getIgnoreTimeLimit(),
                nullValue());
    }
}
