package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.dontshowssp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ShowCondition;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by buhter on 21/03/16
 * https://st.yandex-team.ru/TESTIRT-8788
 */
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@Description("Отправка списка запрещенных SSP-систем в БК")
@Issue("https://st.yandex-team.ru/DIRECT-51971")
@RunWith(Parameterized.class)
public class BsTransportOrderDontShowSSPTest {
    public static final String LOGIN = Logins.LOGIN_TRANSPORT;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String disabledSsp;

    @Parameterized.Parameter(1)
    public List<String> expectedList;

    private Long cid;

    @Parameterized.Parameters(name = "список запрещенных площадок = {1}")
    public static Collection data() {
        Object[][] data = new Object[][]{
                {null, new ArrayList<>()},
                {"", new ArrayList<>()},
                {"[\"Rubicon\"]", Arrays.asList("Rubicon")},
                {"[\"Rubicon\",\"Smaato\"]", Arrays.asList("Rubicon","Smaato")}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void prepare() {
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        CampaignsRecord campaigns = api.userSteps.getDirectJooqDbSteps().campaignsSteps().getCampaignById(cid);
        campaigns.setDisabledSsp(disabledSsp);
        api.userSteps.getDirectJooqDbSteps().campaignsSteps().updateCampaigns(campaigns);
    }

    @Test
    public void test() {
        ShowCondition expectedShowCondition = new ShowCondition();
        expectedShowCondition.setDontShowSSP(expectedList);
        RunBsTransportScriptResponse resp = api.userSteps.transportSteps().sendNewCampaign(2, cid);
        Campaign campaign = api.userSteps.transportSteps().getClientDataRequestCampaign(resp, cid);

        ShowCondition showCondition = campaign.getShowCondition();
        assumeThat("в запросе к БК присутствует объект ShowCondition", showCondition, notNullValue());

        assertThat("отправленный в БК параметр ShowCondition соответствует ожидаемому",
                showCondition, beanDiffer(expectedShowCondition)
                        .useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));

    }
}
