package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.experiment;

import java.time.Instant;
import java.util.Date;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ExperimentsStatus;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;

import static java.time.temporal.ChronoUnit.DAYS;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.nullValue;
import static org.hamcrest.core.IsNot.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 22/07/16
 * https://st.yandex-team.ru/TESTIRT-9758
 */
@Aqua.Test
@Features(FeatureNames.EXPERIMENTS)
@Title("Неотправка в БК неактивных АБ-тестов")
@Description("Неотправка в БК АБ-тестов в статусах New и Stopped")
@Issue("https://st.yandex-team.ru/DIRECT-55133")
public class BsTransportABExperimentNewTest {
    public static final String LOGIN = Logins.LOGIN_WALLET;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static DirectCmdRule cmdRule = DirectCmdRule.defaultRule();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static int shard;
    private Long cidFirst;
    private Long cidSecond;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    public void before() {
        cidFirst = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cidFirst);
        api.userSteps.adsSteps().addDefaultTextAd(pid);
        cidSecond = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cidSecond);
        api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long walletId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .campaignsSteps().getCampaignById(cidFirst).getWalletCid();
        assumeThat("у клиента подключен ОС", walletId, not(equalTo(0L)));
        api.userSteps.campaignFakeSteps().setBSSynced(walletId, true);
        cmdRule.cmdSteps().campaignSteps().createABTest(
                LOGIN,
                cidFirst,
                cidSecond,
                50,
                Date.from(Instant.now().plus(1, DAYS)),
                Date.from(Instant.now().plus(31, DAYS))
        );

        Long experimentId = api.userSteps.getDirectJooqDbSteps().useShard(shard).experimentsSteps()
                .getCampaignsExperimentsRecord(cidFirst).getExperimentId();
        assumeThat("эксперимент остановлен", api.userSteps.getDirectJooqDbSteps().useShard(shard).experimentsSteps()
                .getExperimentsRecord(experimentId).getStatus(), equalTo(ExperimentsStatus.New));

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cidFirst);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cidSecond);
    }

    @Test
    @Title("Проверка отправки в БК первой парной кампании из АБ-эксперимента")
    public void testFirstCampaign() {
        RunBsTransportScriptResponse resp = api.userSteps.transportSteps().sendNewCampaign(shard, cidFirst);
        Campaign campaign = api.userSteps.transportSteps().getClientDataRequestCampaign(resp, cidFirst);
        assertThat("данные по эксперименту для первой кампании не отправляются",
                campaign.getExperimentOnPercentageOfUsers(), nullValue());
    }

    @Test
    @Title("Проверка отправки в БК второй парной кампании из АБ-эксперимента")
    public void testSecondCampaign() {
        RunBsTransportScriptResponse resp = api.userSteps.transportSteps().sendNewCampaign(shard, cidSecond);
        Campaign campaign = api.userSteps.transportSteps().getClientDataRequestCampaign(resp, cidSecond);

        assertThat("данные по эксперименту для второй кампании не отправляются",
                campaign.getExperimentOnPercentageOfUsers(), nullValue());
    }
}
