package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.experiment;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ExperimentsStatus;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ExperimentsRecord;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ExperimentData;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Title;

import static java.time.temporal.ChronoUnit.DAYS;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.core.IsNot.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by buhter on 22/07/16
 * https://st.yandex-team.ru/TESTIRT-9758
 */
@Aqua.Test
@Features(FeatureNames.EXPERIMENTS)
@Description("Отправка в БК активных АБ-тестов с разной процентовкой")
@Title("Отправка в БК АБ-тестов")
@Issue("https://st.yandex-team.ru/DIRECT-55133")
@RunWith(Parameterized.class)
public class BsTransportABExperimentStartedTest {
    public static final String LOGIN = Logins.LOGIN_WALLET;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static DirectCmdRule cmdRule = DirectCmdRule.defaultRule();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static int shard;
    private Long cidFirst;
    private Long cidSecond;
    private ExperimentsRecord experiments;

    @Parameterized.Parameter(0)
    public int percent;

    @Parameterized.Parameters(name = "выставляемый процент - {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {ExperimentData.PERCENT_MIN_VALUE + 1},
                {ExperimentData.PERCENT_MAX_VALUE / 2},
                {ExperimentData.PERCENT_MAX_VALUE - 1},
                {ExperimentData.PERCENT_MAX_VALUE},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void prepare() {
        cidFirst = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cidFirst);
        api.userSteps.adsSteps().addDefaultTextAd(pid);
        cidSecond = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cidSecond);
        api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long walletId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .campaignsSteps().getCampaignById(cidFirst).getWalletCid();
        assumeThat("у клиента подключен ОС", walletId, not(equalTo(0L)));
        api.userSteps.campaignFakeSteps().setBSSynced(walletId, true);
        cmdRule.cmdSteps().campaignSteps().createABTest(
                LOGIN,
                cidFirst,
                cidSecond,
                percent,
                Date.from(Instant.now().plus(1, DAYS)),
                Date.from(Instant.now().plus(31, DAYS))
        );

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cidFirst);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cidSecond);
        Long experimentId = api.userSteps.getDirectJooqDbSteps().useShard(shard).experimentsSteps()
                .getCampaignsExperimentsRecord(cidFirst).getExperimentId();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).experimentsSteps().setExperimentsStatus(experimentId,
                ExperimentsStatus.Started);

        experiments = api.userSteps.getDirectJooqDbSteps().useShard(shard).experimentsSteps()
                .getExperimentsRecord(experimentId);
    }

    @Test
    @Title("Проверка отправки в БК первой парной кампании из АБ-эксперимента")
    public void testFirstCampaign() {
        RunBsTransportScriptResponse resp = api.userSteps.transportSteps().sendNewCampaign(shard, cidFirst);
        Campaign campaign = api.userSteps.transportSteps().getClientDataRequestCampaign(resp, cidFirst);

        ExperimentData expectedExperimentData = new ExperimentData();
        expectedExperimentData.setExperimentID(experiments.getExperimentId());
        expectedExperimentData.setPercentFrom(ExperimentData.PERCENT_MIN_VALUE);
        expectedExperimentData.setPercentTo(percent - 1);
        assertThat("данные по эксперименту отправляемые для первой кампании правильные",
                campaign.getExperimentOnPercentageOfUsers(), beanDiffer(expectedExperimentData));
    }

    @Test
    @Title("Проверка отправки в БК второй парной кампании из АБ-эксперимента")
    public void testSecondCampaign() {
        RunBsTransportScriptResponse resp = api.userSteps.transportSteps().sendNewCampaign(shard, cidSecond);
        Campaign campaign = api.userSteps.transportSteps().getClientDataRequestCampaign(resp, cidSecond);

        ExperimentData expectedExperimentData = new ExperimentData();
        expectedExperimentData.setExperimentID(experiments.getExperimentId());
        expectedExperimentData.setPercentFrom(percent);
        expectedExperimentData.setPercentTo(ExperimentData.PERCENT_MAX_VALUE);
        assertThat("данные по эксперименту отправляемые для второй кампании правильные",
                campaign.getExperimentOnPercentageOfUsers(), beanDiffer(expectedExperimentData));
    }
}
