package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.extendedgeotargeting;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum.ENABLE_AREA_OF_INTEREST_TARGETING;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 08/02/16.
 * https://st.yandex-team.ru/TESTIRT-8459
 */
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-50457")
@Title("Транспорт: отправка параметра расширенного геотаргетинга")
@Stories(StoriesNames.CAMPAIGN_PARAMS_EXTENDED_GEO)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportExtendedGeotargetingTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public CampaignsType campaignsType;

    @Parameterized.Parameter(1)
    public YesNoEnum optionValue;

    @Parameterized.Parameter(2)
    public int expectedSendingValue;

    @Parameterized.Parameters(name = "тип кампании - {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {CampaignsType.TEXT, YesNoEnum.YES, 0},
                {CampaignsType.PERFORMANCE, YesNoEnum.YES, 0},
                {CampaignsType.DYNAMIC, YesNoEnum.YES, 0},
                {CampaignsType.MOBILE_CONTENT, YesNoEnum.YES, 0},
                {CampaignsType.TEXT, YesNoEnum.NO, 1},
                {CampaignsType.PERFORMANCE, YesNoEnum.NO, 1},
                {CampaignsType.DYNAMIC, YesNoEnum.NO, 1},
                {CampaignsType.MOBILE_CONTENT, YesNoEnum.NO, 1},
        };
        return Arrays.asList(data);
    }

    private static int shard;
    private Long cid;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.campaignSteps().campaignsUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap().withId(cid)
                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                .withSettings(new TextCampaignSettingMap()
                                        .withOption(ENABLE_AREA_OF_INTEREST_TARGETING)
                                        .withValue(optionValue)))));
        api.userSteps.campaignFakeSteps().setType(cid, campaignsType);
    }

    @Test
    public void testTransportOfDirectCampaignTypeTest() {
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());
        assertThat("при отправке кампании  отправляется правильное значение ContentType"
                , campaign.getStatusNoExtendedGeotargeting(), equalTo(expectedSendingValue));
    }

}
