package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.filtrationbydontshowdomains;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.google.common.collect.ImmutableList;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.direct.db.steps.JooqCampaignsOpts;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.emptyList;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.direct.db.steps.JooqCampaignsOpts.REQUIRE_FILTRATION_BY_DONT_SHOW_DOMAINS;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-114167")
@Title("Транспорт: отправка параметра для включения фильтрации по списку запрещенных доменов на внутренних площадках")
@Stories(StoriesNames.CAMPAIGN_PARAMS_FILTRATION_BY_DONT_SHOW_DOMAINS)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class RequireFiltrationByDontShowDomains {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public CampaignsType campaignsType;

    @Parameterized.Parameter(1)
    public boolean optionValue;

    @Parameterized.Parameter(2)
    public Integer expectedSendingValue;

    @Parameterized.Parameters(name = "Тип кампании - {0}, отправляемое значение - {2}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {CampaignsType.text, true, 1},
                {CampaignsType.dynamic, true, 1},
                {CampaignsType.mobile_content, true, 1},
                {CampaignsType.cpm_banner, true, 1},
                {CampaignsType.performance, true, 1},

                {CampaignsType.text, false, null},
                {CampaignsType.dynamic, false, null},
                {CampaignsType.mobile_content, false, null},
                {CampaignsType.cpm_banner, false, null},
                {CampaignsType.performance, false, null},
        };
        return Arrays.asList(data);
    }

    private static int shard;
    private Long cid;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
        shard = api.userSteps.getDirectJooqDbSteps().shardingSteps().getShardByLogin(login);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        List<JooqCampaignsOpts> opts = optionValue ? ImmutableList.of(REQUIRE_FILTRATION_BY_DONT_SHOW_DOMAINS) : emptyList();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().setOpts(cid, opts);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().setType(cid, campaignsType);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
    }

    @Test
    public void testTransportOfDirectCampaignTypeTest() {
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                .sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, cid);
        assumeThat("Кампания отправляется в БК", campaign, notNullValue());
        assertThat("При отправке кампании в БК отправляется правильное значение RequireFiltrationByDontShowDomains",
                campaign.getRequireFiltrationByDontShowDomains(), equalTo(expectedSendingValue));
    }
}
