package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.finance;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsArchived;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.balanceclient.NotifyOrder2JSONRequest;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.GoalContext;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.direct.utils.money.Currency.RUB;
import static ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.balanceclient.NotifyOrder2JSONRequest.DIRECT_SERVICE_ID;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;
import static ru.yandex.autotests.irt.testutils.beandiffer.beanconstraint.BeanConstraints.ignore;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки объектов архивной кампании при пополнении её счёта")
@Stories(StoriesNames.CAMPAIGN_PARAMS_FINANCE)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/TESTIRT-1869")
public class BsTransportOfArchivedCampaignTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;
    private static Long cid;
    private static Long pid;
    private static Long bid;
    private static Long bidsId;
    private static Long retargetingId;

    private static Campaign campaign;
    private static Context context;
    private static Banner banner;
    private static Phrase phrase;
    private static GoalContext goalContext;

    @BeforeClass
    public static void prepareData() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        api.userSteps.getDirectJooqDbSteps().useShard(shard);
        Long retargetingConditionId = helpSteps.addRetargetingListsForUserIfNotExists(LOGIN).get(0);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        bidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId);
        retargetingId = api.userSteps.audienceTargetsSteps().addWithRetargetingList(LOGIN, pid, retargetingConditionId);
        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        api.userSteps.getDirectJooqDbSteps().campaignsSteps().makeCampaignReadyForArchive(cid);
        api.userSteps.campaignSteps().campaignsArchive(cid);
        api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);

        CampaignsRecord campaigns = api.userSteps.getDirectJooqDbSteps().campaignsSteps().getCampaignById(cid);
        assumeThat("кампания заархивирована", campaigns.getArchived(), equalTo(CampaignsArchived.Yes));
        assumeThat("кампания синхронизирована", campaigns.getStatusbssynced(), equalTo(CampaignsStatusbssynced.Yes));

        BannersRecord bannersRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(bid);
        assumeThat("баннер синхронхронизирован", bannersRecord.getStatusbssynced(), equalTo(BannersStatusbssynced.Yes));

        PhrasesRecord phrasesRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().getPhrases(pid);
        assumeThat("фраза синхронизирована", phrasesRecord.getStatusbssynced(), equalTo(PhrasesStatusbssynced.Yes));

        api.userSteps.getDarkSideSteps().getBalanceClientNotifyOrderJsonSteps().notifyOrderNoErrors(
                new NotifyOrder2JSONRequest()
                        .withServiceId(DIRECT_SERVICE_ID)
                        .withServiceOrderId(cid)
                        .withTimestamp()
                        .withConsumeQty(150.0f)
                        .withProductCurrency(RUB.value()));

        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        RunBsTransportScriptResponse response =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(response, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
        phrase = context != null ? context.getPhrase(bidsId) : null;
        goalContext = context != null ? context.getGoalContext(retargetingId) : null;
    }

    @Test
    @Title("Отправка архивной кампании в БК при пополнении её счёта")
    public void testCampaign() {
        Campaign expectedCampaign = helpSteps.buildExpectedCampaignObjFromDb(cid, shard, UpdateInfo.UPDATE);
        assertThat("кампания отправлена в БК", campaign,
                beanEquivalent(expectedCampaign).fields(ignore("discountHistory", "ndsHistory")));
    }

    @Test
    @Title("Отправка группы, принадлежащей архивной кампании, в БК при пополнении счёта кампании")
    public void testContext() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("группа отправлена в БК", context,
                beanEquivalent(expectedContext).fields(ignore("geo")));
    }

    @Test
    @Title("Отправка баннера, принадлежащего архивной кампании, в БК при пополнении счёта кампании")
    public void testBanner() {
        Banner expectedBanner = helpSteps.buildExpectedBannerObjFromDb(bid, shard, UpdateInfo.UPDATE);
        assertThat("баннер отправлен в БК", banner, beanEquivalent(expectedBanner));
    }

    @Test
    @Title("Отправка фразы, принадлежащей архивной кампании, в БК при пополнении счёта кампании")
    public void testPhrase() {
        Phrase expectedPhrase = helpSteps.buildExpectedPhraseObjFromDb(bidsId, shard, UpdateInfo.UPDATE);
        assertThat("фраза отправлена в БК", phrase, beanEquivalent(expectedPhrase));
    }

    @Test
    @Title("Отправка ретаргетинга, принадлежащего архивной кампании, в БК при пополнении счёта кампании")
    public void testRetargeting() {
        GoalContext expectedGoalContext =
                helpSteps.buildExpectedRetargetingObjFromDb(retargetingId, shard, UpdateInfo.UPDATE);
        assertThat("ретаргетинг отправлен в БК", goalContext, beanEquivalent(expectedGoalContext));
    }
}
