package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.finance;

import java.util.List;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.http.response.json.ClientsCreateResponse;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.ConvertType;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.SetDiscountInfo;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.DiscountHistoryElem;
import ru.yandex.autotests.directapi.darkside.steps.DarkSideSteps;
import ru.yandex.autotests.directapi.model.api5.agencyclients.AddRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.hasItems;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.direct.db.steps.ClientsOptionsSteps.ClientFlagsEnum.CREATE_WITHOUT_WALLET;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК графика скидок")
@Stories(StoriesNames.CAMPAIGN_PARAMS_FINANCE)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/TESTIRT-1869")
public class BsTransportOfDiscountHistoryTest {

    private static final Currency CURRENCY = Currency.RUB;
    private static final int EXPECTED_DISCOUNT_1 = 4;
    private static final int EXPECTED_DISCOUNT_2 = 17;

    private static final String MANAGER_LOGIN = Logins.LOGIN_MNGR;

    @ClassRule
    public static ApiSteps api = new ApiSteps().wsdl(APIPort_PortType.class).as(MANAGER_LOGIN);
    private static DarkSideSteps darkSideSteps = api.userSteps.getDarkSideSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private String login;
    private int shard;

    @Before
    public void before() {
        String userLogin = AddRequestMap.generateLogin("transport-nds-");
        ClientsCreateResponse createClientResponse = darkSideSteps.getClientsSteps()
                .createManagerClient(userLogin, MANAGER_LOGIN, CURRENCY);
        login = createClientResponse.getLogin();
        Integer clientId = Integer.parseInt(createClientResponse.getClientId());
        api.userSteps.clientFakeSteps().setVATRate(login, 20.0);

        api.userSteps.getDirectJooqDbSteps().useShardForLogin(login);
        api.userSteps.getDirectJooqDbSteps().clientsOptionsSteps().setClientFlag(clientId.longValue(), CREATE_WITHOUT_WALLET);
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Test
    @Title("Проверка отправки графика скидок с одним элементом в БК")
    public void testDiscountHistoryWithOneElement() {
        api.userSteps.clientFakeSteps().setDiscount(api.userSteps.clientFakeSteps().getClientData(login).getClientID(), EXPECTED_DISCOUNT_1);
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        RunBsTransportScriptResponse response = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(response, cid);
        List<DiscountHistoryElem> discountHistory = campaign.getDiscountHistory();

        DiscountHistoryElem expectedDiscountHistoryElem = new DiscountHistoryElem();
        expectedDiscountHistoryElem.setDiscount(EXPECTED_DISCOUNT_1);
        assertThat("значение скидки соответствует ожидаемому", discountHistory, allOf(
                notNullValue(),
                hasItem(beanEquals(expectedDiscountHistoryElem))));
    }

    @Test
    @Title("Проверка корректности отправки графика скидок с двумя элементами в БК")
    public void testDiscountHistoryWithTwoElements() {
        String clientID = api.userSteps.clientFakeSteps().getClientData(login).getClientID();
        api.userSteps.clientFakeSteps().setDiscount(clientID,
                new SetDiscountInfo(EXPECTED_DISCOUNT_1, "2014-01-01", "2014-04-01"),
                new SetDiscountInfo(EXPECTED_DISCOUNT_2, "2015-01-01", "2015-04-01"));
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        RunBsTransportScriptResponse response = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(response, cid);
        List<DiscountHistoryElem> discountHistory = campaign.getDiscountHistory();

        DiscountHistoryElem expectedDiscountHistoryElem1 = new DiscountHistoryElem();
        expectedDiscountHistoryElem1.setDiscount(EXPECTED_DISCOUNT_1);
        DiscountHistoryElem expectedDiscountHistoryElem2 = new DiscountHistoryElem();
        expectedDiscountHistoryElem1.setDiscount(EXPECTED_DISCOUNT_2);
        assertThat("значение скидки соответствует ожидаемому", discountHistory, allOf(
                notNullValue(),
                hasItems(
                        beanEquals(expectedDiscountHistoryElem1),
                        beanEquals(expectedDiscountHistoryElem2))));
    }
}
