package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.finance;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.matchers.BeanCompareStrategy;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.number.OrderingComparison.greaterThan;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directapi.darkside.Logins.LOGIN_AGENCY;
import static ru.yandex.autotests.directapi.darkside.Logins.LOGIN_MNGR;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки полей Group и GroupOrder для общего счета")
@Stories(StoriesNames.CAMPAIGN_PARAMS_FINANCE)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfGroupParamsTest {

    private static final float SUM = 345000;

    @ClassRule
    public static ApiSteps api = new ApiSteps().wsdl(APIPort_PortType.class).as(LOGIN_AGENCY);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private int shard;

    private Long cid;
    private Long walletCid;

    private Campaign wallet;
    private int walletOrderId;

    @Before
    public void before() {
        // создаем клиента с кампанией
        api.userSteps.clientFakeSteps().enableToCreateSubClients(LOGIN_AGENCY);
        CreateNewSubclientResponse createNewSubclientResponse = api.userSteps.clientSteps()
                .createNewServicedSubClient("transport-wallet-", LOGIN_MNGR, Currency.RUB);
        String login = createNewSubclientResponse.getLogin();
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.getDirectJooqDbSteps().useShard(shard);
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        api.userSteps.campaignFakeSteps().makeCampaignFullyModerated(cid);

        // подключаем общий счет
        api.userSteps.clientFakeSteps().enableAgencyWallet(LOGIN_AGENCY);
        api.userSteps.financeSteps().enableSharedAccount(login);
        walletCid = api.userSteps.getDirectJooqDbSteps().campaignsSteps().getCampaignById(cid).getWalletCid();
        api.userSteps.campaignFakeSteps().setCampaignSum(walletCid, SUM);

        // отправляем кампанию-кошелек
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, walletCid);
        wallet = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, walletCid);
        walletOrderId = Integer.parseInt(
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataResponseCampaign(resp, walletCid).getId());
    }


    @Test
    @Title("Отправка в БК параметров Order и GroupOrder для кампании-кошелька")
    public void testTransportOfGroupParamsForWallet() {
        Campaign expectedCampaign =
                helpSteps.buildExpectedCampaignObjFromDb(walletCid, shard, UpdateInfo.UPDATE);
        expectedCampaign.setGroupOrder(1);
        expectedCampaign.setGroupOrderID(0);
        assertThat("Отправленная в БК кампания с общим счетом соответствует ожидаемой",
                wallet, helpSteps.campaignReq1Matcher(expectedCampaign));
    }

    @Test
    @Title("Отправка в БК параметров Group и GroupOrder для кампании под общим счетом")
    public void testTransportOfGroupParamsForCampaignUnderWallet() {
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);

        Campaign expectedCampaign =
                helpSteps.buildExpectedCampaignObjFromDb(cid, shard, UpdateInfo.UPDATE);
        expectedCampaign.setGroupOrder(0);
        expectedCampaign.setGroupOrderID(walletOrderId);
        assertThat("Отправленная в БК кампания с общим счетом соответствует ожидаемой",
                campaign, helpSteps.campaignReq1Matcher(expectedCampaign));
    }
}
