package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.finance;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;
import static ru.yandex.autotests.irt.testutils.beandiffer.beanconstraint.BeanConstraints.only;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки суммы для валютных и невалютных клиентов")
@Stories(StoriesNames.CAMPAIGN_PARAMS_FINANCE)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/TESTIRT-1869")
@RunWith(Parameterized.class)
public class BsTransportOfSumTest {

    private static final double SOME_SUM = 3.14;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private int shard;

    @Parameterized.Parameter(0)
    public Currency currency;

    @Parameterized.Parameter(1)
    public String login;

    @Parameterized.Parameter(2)
    public double expectedSum;

    @Parameterized.Parameter(3)
    public double expectedSumCur;

    @Parameterized.Parameters(name = "валюта = {0}, клиент = {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Currency.RUB, Logins.LOGIN_RUB, 0.0, SOME_SUM}
        });
    }

    @Before
    public void before() {
        api.as(login);
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Test
    @Title("Проверка отправки в БК суммы кампании")
    public void testSumAndSumCur() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setCampaignSum(cid, (float) SOME_SUM);
        api.userSteps.campaignFakeSteps().makeCampaignFullyModerated(cid);

        RunBsTransportScriptResponse response = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        Campaign actualCampaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(response, cid);

        Campaign expectedCampaign = new Campaign();
        expectedCampaign.setSum(expectedSum);
        expectedCampaign.setSumCur(expectedSumCur);
        assertThat("сумма кампании соответствует ожидаемой", actualCampaign,
                beanDiffer(expectedCampaign).fields(only("sum", "sumCur")));
    }
}
