package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.finance;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.darkside.Logins.LOGIN_AGENCY;
import static ru.yandex.autotests.directapi.darkside.Logins.LOGIN_MNGR;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки валюты общего счета для валютных клиентов")
@Stories(StoriesNames.CAMPAIGN_PARAMS_FINANCE)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportOfWalletCurrencyTest {

    private static final String AGENCY_RUB = LOGIN_AGENCY;
    private static final float SUM = 345000;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private int shard;
    private Long cid;
    private Campaign wallet;

    @Parameterized.Parameter(0)
    public Currency currency;

    @Parameterized.Parameter(1)
    public String agencyLogin;

    @Parameterized.Parameters(name = "валюта = {0}, агентство = {1}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {Currency.RUB, AGENCY_RUB},
        };
        return Arrays.asList(data);
    }


    @Before
    public void before() {
        // инициализируем степы для заданного агентства
        api.wsdl(APIPort_PortType.class).as(agencyLogin);
        // создаем клиента с кампанией
        api.userSteps.clientFakeSteps().enableToCreateSubClients(agencyLogin);
        CreateNewSubclientResponse createNewSubclientResponse = api.userSteps.clientSteps()
                .createNewServicedSubClient("transport-wallet-", LOGIN_MNGR, currency);
        String login = createNewSubclientResponse.getLogin();
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.getDirectJooqDbSteps().useShard(shard);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        api.userSteps.campaignFakeSteps().makeCampaignFullyModerated(cid);

        // подключаем общий счет
        api.userSteps.clientFakeSteps().enableAgencyWallet(LOGIN_AGENCY);
        api.userSteps.financeSteps().enableSharedAccount(login);
        Long walletCid = api.userSteps.getDirectJooqDbSteps().campaignsSteps().getCampaignById(cid).getWalletCid();
        api.userSteps.campaignFakeSteps().setCampaignSum(walletCid, SUM);

        // отправляем кампанию-кошелек
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, walletCid);
        wallet = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, walletCid);
    }

    @Test
    @Title("Отправка в БК валюты кампании-кошелька")
    public void testTransportOfWalletCurrency() {
        assertThat("Отправленный в БК код валюты соответствует ожидаемому",
                wallet.getCurrencyIsoCode(), equalTo(currency.getIsoCode()));
    }

    @Test
    @Title("Отправка в БК валюты кампании под общим счетом")
    public void testTransportOfCampaignUnderWalletCurrency() {
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assertThat("Отправленный в БК код валюты соответствует ожидаемому",
                campaign.getCurrencyIsoCode(), equalTo(currency.getIsoCode()));
    }
}
