package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.geocoef;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.common.collect.ImmutableList;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.GeoMultiplierValuesRecord;
import ru.yandex.autotests.direct.utils.model.RegionIDValues;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.BidMultiplierConditionBuilder;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ExpressionCoefItem;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ExpressionCoefs;
import ru.yandex.autotests.directapi.darkside.model.multipliers.DirectAtom;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.darkside.model.BidMultiplierUtils.geoBsAtomRegion;
import static ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign.REGION_COEF;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.checkBsUnifiedMultipliers;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Title("Транспорт: проверка отправки скрытого параметра RegionCoef для Крыма на уровне кампании")
@Stories(StoriesNames.CAMPAIGN_PARAMS_REGIONCOEF)
@Features(FeatureNames.CAMPAIGNS)
@Issue("https://st.yandex-team.ru/DIRECT-67328")
public class BsTransportOfOrderHiddenRegionCoefForCrimeaTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    private static final RegionIDValues RUSSIA = RegionIDValues.RUSSIA;
    private static final RegionIDValues CRIMEA = RegionIDValues.CRIMEA;

    private static final Short FIRST_COEF = 50;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    @Rule
    public Trashman trashman = new Trashman(api);

    private Long cid;
    private Long pid;
    private RunBsTransportScriptResponse resp;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void before() {
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
    }

    @Test
    @Title("Отправка в БК корректировки RegionCoef на уровне кампании, две корректировки, одна из них для Крыма (скрытая)")
    public void testTransportOfOrderRegionCoefOneGroupSingleCoef() {
        List<GeoMultiplierValuesRecord> multipliers = Arrays.asList(
                new GeoMultiplierValuesRecord().setRegionId(RUSSIA.getId().longValue()).setMultiplierPct(FIRST_COEF)
                        .setIsHidden(0),
                new GeoMultiplierValuesRecord().setRegionId(CRIMEA.getId().longValue()).setMultiplierPct(FIRST_COEF)
                        .setIsHidden(1));

        api.userSteps.getDirectJooqDbSteps().useShard(shard).multipliersSteps()
                .saveGeoMultiplierRecords(cid, multipliers);

        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Map<String, Integer> expected = new HashMap<>();
        expected.put(String.valueOf(RUSSIA.getId()), FIRST_COEF.intValue());
        expected.put(String.valueOf(CRIMEA.getId()), FIRST_COEF.intValue());

        Map<String, Map> orderMap = helpSteps.getOrderMap(resp, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, cid);

        assumeThat("в БК отправлен заказ (кампания)", orderMap, notNullValue());
        assertThat("отправленная в БК корректировка RegionCoef на уровне кампании соответствует ожидаемой",
                orderMap.get(REGION_COEF), beanDiffer(expected));

        // проверяем передачу в унифицированном формате
        ExpressionCoefs expressionCoefs = campaign.getExpressionCoefs();
        assumeThat("Отправлен ExpressionCoefs", expressionCoefs, notNullValue());

        List<ExpressionCoefItem> geoCoefs = expressionCoefs.getGeo();
        assumeThat("Отправлен ExpressionCoefs.Geo", geoCoefs, notNullValue());

        List<List<DirectAtom>> expectedExpressionFirst = BidMultiplierConditionBuilder.init()
                .and(geoBsAtomRegion(Integer.toString(RUSSIA.getId())))
                .build();
        List<List<DirectAtom>> expectedExpressionSecond = BidMultiplierConditionBuilder.init()
                .and(geoBsAtomRegion(Integer.toString(CRIMEA.getId())))
                .build();

        checkBsUnifiedMultipliers(geoCoefs,
                ImmutableList.of(FIRST_COEF.intValue(), FIRST_COEF.intValue()),
                ImmutableList.of(expectedExpressionFirst, expectedExpressionSecond));
    }
}
