package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.hidepermalinkinfo;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.CampaignResources;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by andreymak on 19.01.2017.
 * https://st.yandex-team.ru/TESTIRT-10916
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-60678")
@Title("Проверка отправки ORDER.Resources.HidePermalinkInfo")
@Stories(StoriesNames.CAMPAIGN_PARAMS_HIDE_PERMALINK_INFO)
@Features(FeatureNames.CAMPAIGNS)
@RunWith(Parameterized.class)
public class BsTransportHidePermalinkInfoTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    @Parameterized.Parameter(0)
    public boolean setHidePermalinkInfo;

    @Parameterized.Parameter(1)
    public int expectedHidePermalinkInfo;

    @Parameterized.Parameters(name="Проверяем отправку HidePermalinkInfo при значении в БД: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(
                new Object[]{false, 0},
                new Object[]{true, 1}
        );
    }

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Test
    public void testTransportOfCampaignResourcesHidePermalinkInfo() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        if (setHidePermalinkInfo) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                    .setHidePermalinkInfo(cid);
        }

        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign order = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);

        assumeThat("Кампания отправилась ", order, notNullValue());
        CampaignResources campaignResources = order.getResources();
        assertThat("У кампании есть Order.Resources", campaignResources, notNullValue());
        assertThat("В Order.Resources.HidePermalinkInfo выставлено ожидаемое значение",
                campaignResources.getHidePermalinkInfo(), equalTo(expectedHidePermalinkInfo));
    }
}
