package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.is_order_phrase_length_precedence_enabled;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.JooqCampaignsOpts;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки параметра CAMPAIGN_EXACT_PHRASE_MATCHING_ENABLED")
@Stories(StoriesNames.CAMPAIGN_PARAMS_STRATEGY)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportIsOrderPhraseLengthPrecedenceEnabledTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    @Parameterized.Parameter(0)
    public boolean setIsOrderPhraseLengthPrecedenceEnabled;

    @Parameterized.Parameter(1)
    public String expectedIsOrderPhraseLengthPrecedenceEnabled;

    @Parameterized.Parameters(name = "Проверяем отправку IsOrderPhraseLengthPrecedenceEnabled при значении в БД: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(
                new Object[]{true, "1"},
                new Object[]{false, null}
        );
    }

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Test
    public void testTransportOfEnableOrderPhraseLengthPrecedence() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();

        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        if (setIsOrderPhraseLengthPrecedenceEnabled) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                    .setOpts(cid,
                            Collections.singletonList(JooqCampaignsOpts.IS_ORDER_PHRASE_LENGTH_PRECEDENCE_ENABLED));
        }


        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign order = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0,
                cid);

        assumeThat("Кампания отправилась ", order, notNullValue());
        String enableOrderPhraseLengthPrecedence = order.getEnableOrderPhraseLengthPrecedence();
        assertThat("В Order.IsOrderPhraseLengthPrecedenceEnabled выставлено ожидаемое значение",
                enableOrderPhraseLengthPrecedence, equalTo(expectedIsOrderPhraseLengthPrecedenceEnabled));
    }
}
