package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.meaningfulgoals;

import java.math.BigDecimal;
import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.MeaningfulGoal;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Arrays.asList;
import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.CoreMatchers.notNullValue;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки параметров MeaningfulGoals, MeaningfulGoalsHash")
@Stories(StoriesNames.CAMPAIGN_PARAMS_STRATEGY)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.CAMPAIGNS})
public class BsTransportMeaningfulGoalsTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    private Long cid;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    public void before() {
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();

        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
    }

    @Test
    public void testTransportOfMeaningfulGoals() {
        String meaningfulGoals = "[{\"goal_id\": 12, \"value\": 33}]";
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .setCampaignMeaningfulGoals(cid, meaningfulGoals);
        Long strategyId =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cid).getStrategyId();
        if (strategyId != 0) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).strategiesSteps().setStrategyMeaningfulGoals(
                    strategyId, meaningfulGoals);
        }

        Campaign order = getOrder();

        String sentMeaningfulGoalsHash = order.getMeaningfulGoalsHash();
        List<MeaningfulGoal> sentMeaningfulGoals = order.getMeaningfulGoals();

        String expectedHash = "16119043105713850168";
        assertThat("В Order.MeaningfulGoalsHash выставлено ожидаемое значение", sentMeaningfulGoalsHash,
                equalTo(expectedHash));

        List<MeaningfulGoal> expectedMeaningfulGoals = asList(new MeaningfulGoal()
                .withGoalId(12)
                .withValue(BigDecimal.valueOf(33)));
        assertThat("В Order.MeaningfulGoalsHash выставлено ожидаемое значение", sentMeaningfulGoals,
                beanDiffer(expectedMeaningfulGoals).useCompareStrategy(DefaultCompareStrategies.allFields()));
    }

    @Test
    public void testTransportOfEmptyMeaningfulGoals() {
        String meaningfulGoals = null;
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .setCampaignMeaningfulGoals(cid, meaningfulGoals);

        Campaign order = getOrder();

        String sentMeaningfulGoalsHash = order.getMeaningfulGoalsHash();
        List<MeaningfulGoal> sentMeaningfulGoals = order.getMeaningfulGoals();

        assertThat("В Order.MeaningfulGoalsHash выставлено ожидаемое значение", sentMeaningfulGoalsHash,
                nullValue());
        assertThat("В Order.MeaningfulGoalsHash выставлено ожидаемое значение", sentMeaningfulGoals,
                nullValue());
    }

    @Test
    public void testTransportOfMeaningfulGoalsWithEnabledIsMetrikaSourceOfValue() {
        boolean isMetrikaSourceOfValue = true;
        String meaningfulGoals =
                "[{\"goal_id\": 12, \"value\": 33, \"is_metrika_source_of_value\": " + isMetrikaSourceOfValue + "}]";
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .setCampaignMeaningfulGoals(cid, meaningfulGoals);
        Long strategyId =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cid).getStrategyId();
        if (strategyId != 0) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).strategiesSteps().setStrategyMeaningfulGoals(
                    strategyId, meaningfulGoals);
        }

        Campaign order = getOrder();

        List<MeaningfulGoal> sentMeaningfulGoals = order.getMeaningfulGoals();

        assertThat("В Order.MeaningfulGoalsHash выставлено ожидаемое значение",
                sentMeaningfulGoals.get(0).getIsMetrikaSourceOfValue(),
                is(1L));
    }

    @Test
    public void testTransportOfMeaningfulGoalsWithDisabledIsMetrikaSourceOfValue() {
        boolean isMetrikaSourceOfValue = false;
        String meaningfulGoals =
                "[{\"goal_id\": 12, \"value\": 33, \"is_metrika_source_of_value\": " + isMetrikaSourceOfValue + "}]";
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .setCampaignMeaningfulGoals(cid, meaningfulGoals);
        Long strategyId =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cid).getStrategyId();
        if (strategyId != 0) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).strategiesSteps().setStrategyMeaningfulGoals(
                    strategyId, meaningfulGoals);
        }

        Campaign order = getOrder();

        List<MeaningfulGoal> sentMeaningfulGoals = order.getMeaningfulGoals();

        assertThat("В Order.MeaningfulGoalsHash выставлено ожидаемое значение",
                sentMeaningfulGoals.get(0).getIsMetrikaSourceOfValue(),
                is(0L));
    }

    private Campaign getOrder() {
        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign order = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(
                resp, 0, cid);
        assumeThat("Кампания отправилась ", order, notNullValue());
        return order;
    }
}
