package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.minusphrases;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
/**
 * created by pashkus on 17.10.2016
 * https://st.yandex-team.ru/TESTIRT-10250
 */

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-57500")
@Title("Проверка отправки ORDER.ShowCondition.MinusPhrases для текстовой кампании")
@Stories(StoriesNames.CAMPAIGN_PARAMS_MINUSPHRASES)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportOfCampaignMinusPhrasesTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final String FAKE_MINUSWORD = "workaround1";  //Todo: using it until api will apply minus phrases.

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(0)
    public String[] campaignMinusWords;

    @Parameterized.Parameter(1)
    public String[] expectedMinusWordsPattern;

    public static Campaign order;

    @Parameterized.Parameters()
    public static Collection<Object[]> data() {
        return Arrays.asList(
                new Object[] {new String[]{"минусслово"}, null},
                new Object[] {new String[]{"минусслово1", "минусслово2"}, null},
                new Object[] {new String[]{"минус фраза"}, null},
                new Object[] {new String[]{"минус фраза1", "минусслово", "минус фраза2"}, null},
                new Object[] {new String[]{"\"минусслово\""},
                        new String[]{"минусслово ~0"}},
                new Object[] {new String[]{"\"минус фраза1\"", "\"минус фраза2\""},
                        new String[]{"минус фраза1 ~0", "минус фраза2 ~0"}}
                        );
    }

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка: создаем кампанию с минус-фразами на кампанию в json")
    public void prepareTestData() {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withNegativeKeywords(FAKE_MINUSWORD)
                .withDefaultTextCampaign());
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .setCampOptionsMinusWords(cid, JsonUtils.toString(campaignMinusWords, true));
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        order = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
    }


    @Test
    @Title("Проверяем поле ShowCondition.MinusPhrases для текстовой кампании")
    @Description("Ожидаем, что в ShowCondition.MinusPhrases будет список из ppc.camp_options")
    public void testShowConditionMinusPhrases() {
        assumeThat("UpdateInfo отправленной кампании " + UpdateInfo.UPDATE
                , order.getUpdateInfo(), equalTo(UpdateInfo.UPDATE.value()));

        List<String> expectedMinusPhrases = Arrays.asList((expectedMinusWordsPattern != null)?
                expectedMinusWordsPattern:campaignMinusWords);

        assertThat("отправленное в БК поле ShowCondition.MinusPhrases соответствуeт ожиданиям",
                order.getShowCondition().getMinusPhrases(),
                equalTo(expectedMinusPhrases));
    }
}
