package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.mobile;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Title("Транспорт: проверка поля SkAdNetworkCampaignID для мобильных кампаний")
@Stories(StoriesNames.CAMPAIGN_PARAMS_MOBILE_CONTENT)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfSkAdNetworkCampaignIdTest {
    private static final String login = Logins.LOGIN_TRANSPORT;

    private static final Long SLOT = 22L;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static int shard;
    private Long cid;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Before
    public void init() {
        cid = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
    }

    @Test
    public void skAdNetworkCampaignIdWithoutMapping() {
        api.userSteps.getDirectJooqDbSteps().iosSkAdNetworkSteps().deleteSlotsForCampaign(cid);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());
        assertThat("значение SkAdNetworkCampaignID не отправляется, если для кампании не зарезервирован слот",
                campaign.getSkAdNetworkCampaignId(), nullValue());
    }

    @Test
    public void skAdNetworkCampaignIdWithMappingInProperty() {
        api.userSteps.getDirectJooqDbSteps().iosSkAdNetworkSteps().deleteSlotsForCampaign(cid);
        api.userSteps.getDirectJooqDbSteps().iosSkAdNetworkSteps()
                .allocateSlotWithReplace("ru.yandex.autotests.bundle-id", cid, SLOT);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());
        assertThat("значение SkAdNetworkCampaignID отправляется, если для кампании зарезервирован слот",
                campaign.getSkAdNetworkCampaignId(), equalTo(SLOT));
    }
}
