package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.mobilepricecoef;

import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.MobileAdjustmentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки параметра MobilePriceCoef на уровне кампании, удаление")
@Stories(StoriesNames.CAMPAIGN_PARAMS_MOBPRICECOEF)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-42533")
public class BsTransportOfCampaignMobilePriceCoefDeleteTest {

    private static final Integer MOBILE_PRICE_COEF = 50;
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);
    private static int shard;

    private Campaign campaign;
    private RunBsTransportScriptResponse resp;
    private Long cid;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void before() {
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        List<Long> bidModifiers = api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withMobileAdjustment(new MobileAdjustmentMap()
                                .withBidModifier(MOBILE_PRICE_COEF)
                        )
                        .withCampaignId(cid)
        );

        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("отправленная в БК корректировка MobilePriceCoef на уровне кампании соответствует ожидаемой",
                campaign.getMobilePriceCoef(), equalTo(MOBILE_PRICE_COEF.toString()));
        assumeThat("в БК отправлена корректировка MobileIOSPriceCoef со значение undef на уровне кампании",
                helpSteps.getOrderMap(resp, cid).get(Campaign.MOBILE_IOS_PRICE_COEF), equalTo(null));
        assumeThat("в БК отправлена корректировка MobileAndroidPriceCoef со значение undef на уровне кампании",
                helpSteps.getOrderMap(resp, cid).get(Campaign.MOBILE_ANDROID_PRICE_COEF), equalTo(null));

        api.userSteps.bidModifiersSteps().bidModifiersDelete(bidModifiers.get(0));

        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
    }

    @Test
    @Title("Отправка в БК корректировки MobilePriceCoef со значением undef на уровне кампании после ее удаления")
    public void testTransportOfCampaignMobilePriceCoef() {
        assertThat("в БК отправлена корректировка MobilePriceCoef со значение undef на уровне кампании",
                helpSteps.getOrderMap(resp, cid).get(Campaign.MOBILE_PRICE_COEF), equalTo(null));
        assertThat("отправленная в БК корректировка MobileIOSPriceCoef на уровне кампании соответствует ожидаемой",
                campaign.getMobileIOSPriceCoef(), equalTo(null));
        assertThat("отправленная в БК корректировка MobileAndroidPriceCoef на уровне кампании соответствует ожидаемой",
                campaign.getMobileAndroidPriceCoef(), equalTo(null));
    }
}
