package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.mobilepricecoef;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.MobileAdjustmentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки параметра MobilePriceCoef на уровне кампании")
@Stories(StoriesNames.CAMPAIGN_PARAMS_MOBPRICECOEF)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-42533")
@RunWith(Parameterized.class)
public class BsTransportOfCampaignMobilePriceCoefTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static int shard;
    private Campaign campaign;

    @Parameterized.Parameter(0)
    public Integer mobilePriceCoef;

    @Parameterized.Parameters(name = "коэффициент = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {50},
                {100},
                {400}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void before() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withMobileAdjustment(new MobileAdjustmentMap()
                                .withBidModifier(mobilePriceCoef)
                        )
                        .withCampaignId((long) cid)
        );

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
    }

    @Test
    @Title("Отправка в БК корректировки MobilePriceCoef на уровне кампании")
    public void testTransportOfCampaignMobilePriceCoef() {
        assertThat("отправленная в БК корректировка MobilePriceCoef на уровне кампании соответствует ожидаемой",
                campaign.getMobilePriceCoef(), equalTo(mobilePriceCoef.toString()));
        assertThat("отправленная в БК корректировка MobileIOSPriceCoef на уровне кампании соответствует ожидаемой",
                campaign.getMobileIOSPriceCoef(), equalTo(null));
        assertThat("отправленная в БК корректировка MobileAndroidPriceCoef на уровне кампании соответствует ожидаемой",
                campaign.getMobileAndroidPriceCoef(), equalTo(null));
    }
}
