package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.mobilepricecoef;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.MobileMultiplierValuesOsType;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.MobileAdjustmentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки параметра MobilePriceCoef на уровне кампании, обновление")
@Stories(StoriesNames.CAMPAIGN_PARAMS_MOBPRICECOEF)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-42533")
@RunWith(Parameterized.class)
public class BsTransportOfCampaignMobilePriceCoefUpdateTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final Integer MOBILE_PRICE_COEF = 50;
    private static final Short UPDATED_MOBILE_PRICE_COEF = 150;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);

    private static int shard;
    private Campaign campaign;

    @Parameterized.Parameter()
    public MobileMultiplierValuesOsType updatedOsType;

    @Parameterized.Parameter(1)
    public String expectedMobileIOSPriceCoef;

    @Parameterized.Parameter(2)
    public String expectedMobileAndroidPriceCoef;

    @Parameterized.Parameters(name = "тип ОС при обновлении = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {MobileMultiplierValuesOsType.ios, UPDATED_MOBILE_PRICE_COEF.toString(), null},
                {MobileMultiplierValuesOsType.android, null, UPDATED_MOBILE_PRICE_COEF.toString()},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void before() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        List<Long> bidModifiers = api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withMobileAdjustment(new MobileAdjustmentMap()
                                .withBidModifier(MOBILE_PRICE_COEF)
                        )
                        .withCampaignId((long) cid)
        );

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("отправленная в БК корректировка MobilePriceCoef на уровне кампании соответствует ожидаемой",
                campaign.getMobilePriceCoef(), equalTo(MOBILE_PRICE_COEF.toString()));
        assumeThat("отправленная в БК корректировка MobileIOSPriceCoef на уровне кампании соответствует ожидаемой",
                campaign.getMobileIOSPriceCoef(), equalTo(null));
        assumeThat("отправленная в БК корректировка MobileAndroidPriceCoef на уровне кампании соответствует ожидаемой",
                campaign.getMobileAndroidPriceCoef(), equalTo(null));

        api.userSteps.bidModifiersSteps().bidModifiersDelete(bidModifiers.get(0));
        jooqDbSteps.multipliersSteps().saveMobileMultiplierValues(cid, UPDATED_MOBILE_PRICE_COEF, updatedOsType);
        jooqDbSteps.campaignsSteps().setCampaignsStatusBsSynced(cid, CampaignsStatusbssynced.No);


        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
    }

    @Test
    @Title("Отправка в БК корректировки MobilePriceCoef на уровне кампании при ее обновлении")
    public void testTransportOfCampaignMobilePriceCoef() {
        assertThat("отправленная в БК корректировка MobilePriceCoef на уровне кампании соответствует ожидаемой",
                campaign.getMobilePriceCoef(), equalTo(null));
        assertThat("отправленная в БК корректировка MobileIOSPriceCoef на уровне кампании соответствует ожидаемой",
                campaign.getMobileIOSPriceCoef(), equalTo(expectedMobileIOSPriceCoef));
        assertThat("отправленная в БК корректировка MobileAndroidPriceCoef на уровне кампании соответствует ожидаемой",
                campaign.getMobileAndroidPriceCoef(), equalTo(expectedMobileAndroidPriceCoef));
    }
}
