package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.pageid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampOptionsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ShowCondition;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by hmepas on 2018.07.10
 * https://st.yandex-team.ru/TESTIRT-12282
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@Description("Отправка списка разрешенных к позаку PageID")
@Issue("https://st.yandex-team.ru/DIRECT-79079")
@RunWith(Parameterized.class)
public class BsTransportOrderPageIDTest {
    public static final String LOGIN = Logins.LOGIN_TRANSPORT;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trashman = new Trashman(api);
    @Parameterized.Parameter(0)
    public String allowedPageIds;

    @Parameterized.Parameter(1)
    public List<Integer> expectedList;

    private Long cid;

    @Parameterized.Parameters(name = "список площадок для показа в БД: {0} отправили {1}")
    public static Collection data() {
        Object[][] data = new Object[][]{
                {null, new ArrayList<>()},
                {"[]", new ArrayList<>()},
                {"[\"-100\", -1, 456, 0]", Arrays.asList(456)},
                {"[\"asdf\"]", new ArrayList<>()},
                {"[\"123\", \"asdf\"]", Arrays.asList(123)},
                {"[\"1111\", 1235]", Arrays.asList(1111, 1235)},
                {"[\"12356\",\"6789\"]", Arrays.asList(12356, 6789)}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void prepare() {
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        CampOptionsRecord campOptions = api.userSteps.getDirectJooqDbSteps().campaignsSteps().getCampOptionsById(cid);
        campOptions.setAllowedPageIds(allowedPageIds);
        api.userSteps.getDirectJooqDbSteps().campaignsSteps().updateCampOptions(campOptions);
    }

    @Test
    public void test() {
        ShowCondition expectedShowCondition = new ShowCondition();
        expectedShowCondition.setPageID(expectedList);
        RunBsTransportScriptResponse resp = api.userSteps.transportSteps().sendNewCampaign(2, cid);
        Campaign campaign = api.userSteps.transportSteps().getClientDataRequestCampaign(resp, cid);

        ShowCondition showCondition = campaign.getShowCondition();
        assumeThat("в запросе к БК присутствует объект ShowCondition", showCondition, notNullValue());

        assertThat("отправленный в БК параметр PageID соответствует ожидаемому",
                showCondition, beanDiffer(expectedShowCondition)
                        .useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));

    }
}
