package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.pagetype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampOptionsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ShowCondition;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.arrayContaining;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by lightelfik on 2018.12.29
 * https://st.yandex-team.ru/DIRECT-85903
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@Description("Отправка списка разрешенных к позаку PageID")
@Issue("https://st.yandex-team.ru/DIRECT-79079")
@RunWith(Parameterized.class)
public class BsTransportOrderPageTypeTest {
    public static final String LOGIN = Logins.LOGIN_TRANSPORT;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trashman = new Trashman(api);
    @Parameterized.Parameter(0)
    public String allowedFrontpageTypes;

    @Parameterized.Parameter(1)
    public List<Integer> expectedPageList;

    private Long cid;

    @Parameterized.Parameters(name = "список площадок для показа в БД: {0} отправили {1}")
    public static Collection data() {
        Object[][] data = new Object[][]{
                {"frontpage", Arrays.asList(111,444)},
                {"frontpage_mobile", Arrays.asList(222,333)},
                {"frontpage,frontpage_mobile", Arrays.asList(111,444,222,333)}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
        cid = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();

        CampaignsRecord campaign = api.userSteps.getDirectJooqDbSteps().campaignsSteps().getCampaignById(cid);
        campaign.setType(CampaignsType.cpm_yndx_frontpage);
        api.userSteps.getDirectJooqDbSteps().campaignsSteps().updateCampaigns(campaign);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        api.userSteps.getDirectJooqDbSteps().campaignsSteps()
                .setCampaignCpmYndxFrontpageAllowedTypes(cid, allowedFrontpageTypes);
    }

    @Test
    public void test() {
        RunBsTransportScriptResponse resp = api.userSteps.transportSteps().sendNewCampaign(2, cid);
        Campaign campaign = api.userSteps.transportSteps().getClientDataRequestCampaign(resp, cid);

        ShowCondition showCondition = campaign.getShowCondition();
        assumeThat("в запросе к БК присутствует объект ShowCondition", showCondition, notNullValue());

        assertThat("отправленный в БК параметр PageID соответствует ожидаемому",
                showCondition.getPageID(), equalTo(expectedPageList));

    }
}
