package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.socdemcoef;

import java.util.List;

import com.yandex.direct.api.v5.general.AgeRangeEnum;
import com.yandex.direct.api.v5.general.GenderEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ExpressionCoefs;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DemographicsAdjustmentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.enums.AgeGroup.YOUNGADULT;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки параметра SocdemCoef на уровне кампании, удаление")
@Stories(StoriesNames.CAMPAIGN_PARAMS_SOCDEMCOEF)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-42533")
public class BsTransportOfCampaignSocdemCoefDeleteTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final int COEF = 150;
    private static final AgeRangeEnum AGE_GROUP = AgeRangeEnum.AGE_25_34;
    private static final GenderEnum GENDER = GenderEnum.GENDER_FEMALE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private Long cid;
    private RunBsTransportScriptResponse resp;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void before() {
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        List<Long> bidModifiers = api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withCampaignId(cid)
                        .withDemographicsAdjustment(new DemographicsAdjustmentMap()
                                .withAge(AGE_GROUP)
                                .withGender(GENDER)
                                .withBidModifier(COEF)
                        )
        );

        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("отправленная в БК корректировка SocdemCoef на уровне кампании соответствует ожидаемой",
                campaign.getSocdemCoef().getFemale().get(YOUNGADULT.toString())
                , equalTo(COEF));

        api.userSteps.bidModifiersSteps().bidModifiersDelete(bidModifiers.get(0));

        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
    }

    @Test
    @Title("Отправка в БК корректировки SocdemCoef на уровне кампании")
    public void testTransportOfCampaignSocdemCoef() {
        assertThat("в БК отправлена корректировка SocdemCoef со значение undef на уровне кампании",
                helpSteps.getOrderMap(resp, cid).get(Campaign.SOCDEM_COEF), equalTo(null));

        // проверяем передачу в унифицированном формате
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        assumeThat("в БК отправлена кампания", campaign, notNullValue());

        ExpressionCoefs expressionCoefs = campaign.getExpressionCoefs();
        assumeThat("Отправлен ExpessionCoefs", expressionCoefs, notNullValue());

        assertThat("в БК отправлена корректировка ExpressionCoefs.Socdem со значение undef на уровне кампании",
                expressionCoefs.getSocdem(), equalTo(null));
    }
}
