package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.sourceinterface;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsSource;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-138230")
@Title("Транспорт: отправка информации об источнике создания кампании")
@Features(FeatureNames.CAMPAIGNS)
public class BsTransportOfSourceInterfaceTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps API = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule SEMAPHORE = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(API);

    private int shard;
    private Long cid;

    @BeforeClass
    public static void beforeClass() {
        API.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Before
    public void setUp() {
        DirectJooqDbSteps jooqDbSteps = API.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
        shard = jooqDbSteps.getCurrentPpcShard();
        cid = API.userSteps.campaignSteps().addDefaultTextCampaign();
        API.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
    }

    private Campaign sendCampaign() {
        RunBsTransportScriptResponse resp = API
                .userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = API.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, cid);
        assumeThat("Кампания отправляется в БК", campaign, notNullValue());
        return campaign;
    }

    @Test
    @Title("Проверка отправки поля SourceInterface для direct-кампании")
    public void testDirectSourceInterface() {
        // direct — source по умолчанию
        Campaign campaign = sendCampaign();
        assertThat("При отправке кампании в БК отправляется правильное значение SourceInterface",
                campaign.getSourceInterface(), is("api"));
    }

    @Test
    @Title("Проверка отправки поля SourceInterface для uac-кампании")
    public void testUacSourceInterface() {
        API.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().setSource(cid, CampaignsSource.uac);
        Campaign campaign = sendCampaign();
        assertThat("При отправке кампании в БК отправляется правильное значение SourceInterface",
                campaign.getSourceInterface(), is("uac"));
    }
}
