package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.stoptime;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ShowCondition;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки параметра StopTime (дата остановки кампании)")
@Stories(StoriesNames.CAMPAIGN_PARAMS_STOPTIME)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportOfStopTimeTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    private static final String FINISH_TIME_OFF = null;
    private static final String FINISH_TIME_FUTURE = "2030-04-04";
    private static final String STOP_TIME_OFF = "";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    @Parameterized.Parameter(0)
    public String finishTime;

    @Parameterized.Parameters(name = "Дата остановки кампании = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {FINISH_TIME_OFF},
                {FINISH_TIME_FUTURE}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Test
    @Title("Отправка в БК параметра StopTime (дата остановки кампании)")
    public void testTransportOfStopTime() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap()
                .withCampaigns(new CampaignUpdateItemMap()
                        .withId(cid)
                        .withEndDate(finishTime))
        );
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);

        ShowCondition showCondition = campaign.getShowCondition();
        assumeThat("в запросе к БК присутствует объект ShowCondition", showCondition, notNullValue());

        String expectedStopTime = convertFinishTimeToStopTime(finishTime);
        assertThat("отправленный в БК параметр StopTime соответствует ожидаемому",
                showCondition.getStopTime(), equalTo(expectedStopTime));
    }

    private String convertFinishTimeToStopTime(String finishTime) {
        if (Objects.equals(finishTime, FINISH_TIME_OFF)) {
            return STOP_TIME_OFF;
        }
        return finishTime.replace("-", "");
    }
}
