package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.strategy.common;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.runners.Parameterized;

import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.assertNullsOrEquals;

public abstract class BsTransportOfMaxBidForAvgCPAOptimizationStrategy {

    protected static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule SEMAPHORE = Semaphore.getSemaphore();

    protected static final float AVG_CPA = 200;

    protected int goalId;
    protected TextCampaignSearchStrategyMap searchStrategy;
    protected TextCampaignNetworkStrategyMap networkStrategy;
    private static final int SHARD = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

    @Parameterized.Parameter
    public Money maxPrice;

    @Parameterized.Parameter(1)
    public Money weeklySpendLimit;

    @Parameterized.Parameters(name = "maxPrice = {0}, weeklySpendLimit = {1}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {null, null},
                {Money.valueOf(50d, Currency.RUB), null},
                {null, Money.valueOf(4567.89d, Currency.RUB)},
                {Money.valueOf(50d, Currency.RUB), Money.valueOf(4567.89d, Currency.RUB)},
        };
        return Arrays.asList(data);
    }

    public abstract void before();

    protected void testTransportOfMaxBidForAvgCPAOptimizationStrategyCommon() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.getDirectJooqDbSteps().useShard(SHARD);
        api.userSteps.getDirectJooqDbSteps().campMetrikaGoalsSteps().addOrUpdateMetrikaGoals(cid, (long) goalId, 100L
                , 100L);
        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap()
                .withCampaigns(new CampaignUpdateItemMap()
                        .withId(cid)
                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyMap()
                                        .withSearch(searchStrategy)
                                        .withNetwork(networkStrategy)))));
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(SHARD, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp,
                cid);

        Money maxPriceExpected = maxPrice;
        if (maxPriceExpected == null && weeklySpendLimit != null) {
            maxPriceExpected = weeklySpendLimit.multiply(0.1f);
        }
        // по DIRECT-88492 конвертация идёт с историческим НДС
        Float maxPriceFixed = maxPriceExpected == null ? null : maxPriceExpected.convert(Currency.YND_FIXED,
                30 * 1.2 / 1.18).floatValue();
        assertNullsOrEquals("отправленный в БК параметр AutoBudgetMaxBidCur соответствует ожидаемому",
                maxPriceExpected == null ? null : maxPriceExpected.floatValue(), campaign.getAutoBudgetMaxBidCur());
        assertNullsOrEquals("отправленный в БК параметр AutoBudgetMaxBid соответствует ожидаемому",
                maxPriceFixed, campaign.getAutoBudgetMaxBid());
    }
}
