package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.strategy.common;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.runners.Parameterized;

import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.assertNullsOrEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

public abstract class BsTransportOfWeekLimitForAverageClickPriceStrategy {
    @ClassRule
    public static final SemaphoreRule SEMAPHORE = Semaphore.getSemaphore();
    protected static final String LOGIN = Logins.LOGIN_TRANSPORT;
    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    protected static final float AVERAGE_CLICK_PRICE = 40;
    private static final int SHARD = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    protected TextCampaignSearchStrategyAddMap searchStrategy;
    protected TextCampaignNetworkStrategyAddMap networkStrategy;

    @Parameterized.Parameter
    public Money weeklyBudget;

    @Parameterized.Parameters(name = "weekLimit = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {null},
                {Money.valueOf(5000.0f, Currency.RUB)}
        };
        return Arrays.asList(data);
    }

    public abstract void before();

    protected void testTransportOfWeekLimitForAverageClickPriceStrategyCommon() {
        Float weeklyBudgetWithVAT = null;
        if (weeklyBudget != null) {
            weeklyBudgetWithVAT = weeklyBudget.addVAT().floatValue();
        }
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(searchStrategy, networkStrategy);
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(SHARD, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp,
                cid);

        Float weeklyBudgetfixed = weeklyBudget == null ? null : weeklyBudget.convert(Currency.YND_FIXED).floatValue();
        assertNullsOrEquals("отправленный в БК параметр AutoBudgetWeekLimitCur соответствует ожидаемому",
                weeklyBudgetWithVAT, campaign.getAutoBudgetWeekLimitCur());
        assertNullsOrEquals("отправленный в БК параметр AutoBudgetWeekLimit соответствует ожидаемому",
                weeklyBudgetfixed, campaign.getAutoBudgetWeekLimit());
    }
}
