package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.strategy.context;

import com.yandex.direct.api.v5.campaigns.MobileAppCampaignNetworkStrategyTypeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.AutoBudget;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumAppInstallsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.directintapi.bstransport.TransportUtils.MOBILE_APP_INSTALL_GOAL_ID;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ppalex on 25.11.16.
 * https://st.yandex-team.ru/TESTIRT-10634
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Description("Транспорт: проверка отправки автобюджетных параметров для стратегии WB_MAXIMUM_APP_INSTALLS на РСЯ")
@Stories(StoriesNames.CAMPAIGN_PARAMS_STRATEGY)
@Feature(FeatureNames.CAMPAIGNS)
@Issues({
        @Issue("https://st.yandex-team.ru/DIRECT-42914"),
        @Issue("https://st.yandex-team.ru/DIRECT-42673"),
})
public class BsTransportOfAutoBudgetForWeekBudgetMaximumAppInstalls {
    private static final Money WEEKLY_SPEND_LIMIT = MoneyCurrency.get(Currency.RUB).getMinWeeklyBudgetAmount();

    private static final String LOGIN = Logins.LOGIN_RUB;

    private static Campaign campaign;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void beforeClass() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);

        Long cid = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();

        // ставим фейковый OrderID, чтобы было на что подложить фейковую статистику
        // можно произвольный, но cid тоже хорошо подходит (он больше настоящих БКшных OrderID)
        Long fakeOrderID = cid;
        jooqDbSteps.campaignsSteps().setOrderId(cid, fakeOrderID);

        MobileAppCampaignSearchStrategyMap mobileAppCampaignSearchStrategyAdd = new MobileAppCampaignSearchStrategyMap()
                .defaultServingOff();

        StrategyMaximumAppInstallsMap strategyMaximumAppInstallsAdd = new StrategyMaximumAppInstallsMap()
                .withWeeklySpendLimit(WEEKLY_SPEND_LIMIT.bidLong().longValue());
        MobileAppCampaignNetworkStrategyMap mobileAppCampaignNetworkStrategyAdd =
                new MobileAppCampaignNetworkStrategyMap()
                        .withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_APP_INSTALLS)
                        .withWbMaximumAppInstalls(strategyMaximumAppInstallsAdd);

        api.userSteps.campaignSteps().campaignsUpdate(
                new UpdateRequestMap().withCampaigns(
                        new CampaignUpdateItemMap().withId(cid).withMobileAppCampaign(
                                new MobileAppCampaignUpdateItemMap().withBiddingStrategy(
                                        new MobileAppCampaignStrategyMap()
                                                .withSearch(mobileAppCampaignSearchStrategyAdd)
                                                .withNetwork(mobileAppCampaignNetworkStrategyAdd)
                                )
                        )
                )
        );

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        RunBsTransportScriptResponse response = api.userSteps.transportSteps().sendSyncedCampaign(shard, cid);
        campaign = api.userSteps.transportSteps().getClientDataRequestCampaign(response, cid);
        assumeThat("кампания была отправлена", campaign, notNullValue());
    }

    @Test
    public void testTransportOfAutoBudgetForWeekBudgetMaximumAppInstallsWithMaxBid() {
        assertThat("отправленный в БК параметр AutoBudget соответствует ожидаемому",
                campaign.getAutoBudget(), equalTo(AutoBudget.YES.transportValue()));
    }

    @Test
    public void testTransportOfAutoBudgetGoalIDForWeekBudgetMaximumAppInstallsWithMaxBid() {
        assertThat("отправленный в БК параметр AutoBudgetGoalID соответствует ожидаемому",
                campaign.getAutoBudgetGoalId(), equalTo(MOBILE_APP_INSTALL_GOAL_ID));
    }

    @Test
    public void testTransportOfAutoBudgetWeekLimitForWeekBudgetMaximumAppInstallsWithMaxBid() {
        assertThat("отправленный в БК параметр AutoBudgetWeekLimit соответствует ожидаемому",
                campaign.getAutoBudgetWeekLimit(),
                equalTo(WEEKLY_SPEND_LIMIT.convert(Currency.YND_FIXED).floatValue())
        );
    }

    @Test
    public void testTransportOfAutoBudgetWeekLimitCurForWeekBudgetMaximumAppInstallsWithMaxBid() {
        assertThat("отправленный в БК параметр AutoBudgetWeekLimitCur соответствует ожидаемому",
                campaign.getAutoBudgetWeekLimitCur(),
                equalTo(WEEKLY_SPEND_LIMIT.addVAT().floatValue())
        );
    }

    // здесь можно было бы также проверить значение AutoBudgetMaxBid,
    // но вычисление этого поля не пережило переход на НДС 20%, и теперь оно вычисляется неправильно.
    // Это сознательно решили не исправлять, см. https://st.yandex-team.ru/DIRECT-88492
    @Test
    public void testTransportOfAutoBudgetMaxBidCurForWeekBudgetMaximumAppInstallsWithMaxBid() {
        assertThat("отправленный в БК параметр AutoBudgetMaxBidCur соответствует ожидаемому",
                campaign.getAutoBudgetMaxBidCur(),
                nullValue());
    }
}
