package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.strategy.context;

import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.strategy.common.BsTransportOfMaxBidForAvgCPAOptimizationStrategy;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals.getRandom;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки параметров AutoBudgetMaxBid и AutoBudgetMaxBidCur " +
        "для стратегии в РСЯ AverageCPAOptimization")
@Stories(StoriesNames.CAMPAIGN_PARAMS_STRATEGY)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportOfMaxBidForAvgCPAOptimizationStrategyTest extends BsTransportOfMaxBidForAvgCPAOptimizationStrategy {
    @Override
    @Before
    public void before() {
        goalId = MetrikaGoals.getGoalForLogin(LOGIN).intValue();
        searchStrategy =
                new TextCampaignSearchStrategyMap().defaultServingOff();
        networkStrategy =
                new TextCampaignNetworkStrategyMap()
                        .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.AVERAGE_CPA)
                        .withAverageCpa(new StrategyAverageCpaMap()
                                .withGoalId((long) goalId)
                                .withBidCeiling((maxPrice == null) ? null :
                                        maxPrice.bidLong().longValue())
                                .withWeeklySpendLimit((weeklySpendLimit == null) ? null :
                                        weeklySpendLimit.bidLong().longValue())
                                .withAverageCpa(Money.valueOf(AVG_CPA).bidLong().longValue()));
    }

    @Test
    @Title("Отправка параметров AutoBudgetMaxBid и AutoBudgetMaxBidCur для стратегии в РСЯ AverageCPAOptimization")
    public void testTransportOfMaxBidForAvgCPAOptimizationStrategy() {
        testTransportOfMaxBidForAvgCPAOptimizationStrategyCommon();
    }
}
