package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.strategy.context;

import java.util.Arrays;

import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ShowCondition;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 06.11.15.
 * https://st.yandex-team.ru/TESTIRT-7669
 */
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки отключения показов в РСЯ для динамической кампании")
@Stories(StoriesNames.CAMPAIGN_PARAMS_STRATEGY)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportOfTargetTypeForDynamicCampaignTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public DynamicTextCampaignSearchStrategyAddMap searchStrategy;

    @Parameterized.Parameter(2)
    public DynamicTextCampaignNetworkStrategyAddMap networkStrategy;

    @Parameterized.Parameter(3)
    public Matcher<Iterable<?>> expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"стратегия на сети выключена",
                        new DynamicTextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        contains(equalTo(3))},
        });
    }

    private static int shard;

    @BeforeClass
    public static void prepareStaticData() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    private Long cid;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareData() {
        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaignWithStrategies(searchStrategy, networkStrategy);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
    }

    @Test
    @Title("Отправка отключения показов в РСЯ")
    public void testTransportOfTargetTypeForShowsDisabledStrategy() {
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        ShowCondition showCondition = campaign.getShowCondition();
        assumeThat("в БК отправлен объект campaign.showCondition", showCondition, notNullValue());

        assertThat("в БК отправлено отключение показов в РСЯ",
                showCondition.getTargetType(), expectedResult);
    }
}
