package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.strategy.context;

import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumClicksAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки параметра AutoBudgetWeekLimitCur для стратегии в РСЯ WeeklyBudget")
@Stories(StoriesNames.CAMPAIGN_PARAMS_STRATEGY)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfWeekLimitForWeeklyBudgetStrategyTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static final float WEEKLY_BUDGET = 5000;
    private static float weeklyBudgetWithVAT = Money.valueOf(WEEKLY_BUDGET, Currency.RUB).addVAT().floatValue();

    @Test
    @Title("Отправка параметра AutoBudgetWeekLimitCur для стратегии в РСЯ WeeklyBudget")
    public void testTransportOfWeekLimitForWeeklyBudgetStrategy() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(login);

        TextCampaignSearchStrategyAddMap searchStrategy =
                new TextCampaignSearchStrategyAddMap().defaultServingOff();
        TextCampaignNetworkStrategyAddMap networkStrategy =
                new TextCampaignNetworkStrategyAddMap()
                        .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                        .withWbMaximumClicks(new StrategyMaximumClicksAddMap()
                                .withWeeklySpendLimit(Money.valueOf(WEEKLY_BUDGET).bidLong().longValue()));
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(searchStrategy, networkStrategy);
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);

        assertThat("отправленный в БК недельный бюджет в РСЯ соответствует ожидаемому",
                campaign.getAutoBudgetWeekLimitCur(), equalTo(weeklyBudgetWithVAT));
    }
}
