package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.strategy.search;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.AutoBudget;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-10613
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Description("Транспорт: проверка отправки параметра AutoBudgetGoalID для стратегии AVERAGE_CPI на поиске")
@Stories(StoriesNames.CAMPAIGN_PARAMS_STRATEGY)
@Feature(FeatureNames.CAMPAIGNS)
public class BsTransportOfAutoBudgetForDisabledAverageCPIStrategySearchTest {
    private static final String LOGIN = Logins.LOGIN_RUB;

    private static Campaign campaign;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void beforeClass() {
        Integer shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        Long cid = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        Long pid = api.userSteps.adGroupsSteps().addDefaultMobileGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultMobileAppAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания была отправлена", campaign, notNullValue());
    }

    @Test
    @Title("Отправка правильного параметра AutoBudget когда AVERAGE_CPI не используется")
    public void testTransportOfAutoBudgetWithoutAverageCPI() {
        assertThat("отправленный в БК параметр AutoBudget соответствует ожидаемому",
                campaign.getAutoBudget(), equalTo(AutoBudget.NO.transportValue()));
    }

    @Test
    @Title("Неотправка параметра AutoBudgetGoalID когда AVERAGE_CPI не используется")
    public void testTransportOfAutoBudgetGoalIDWithoutAverageCPI() {
        assertThat("параметр AutoBudgetGoalID не отправляется в БК",
                campaign.getAutoBudgetGoalId(), nullValue());
    }
}
