package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.strategy.search;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.SmartCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.PerformanceBannersRule;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCrrMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.autotests.irt.testutils.beandiffer2.differ.AlwaysOkDiffer;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;
import static ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath.newPath;

@Aqua.Test
@Title("Транспорт: проверка отправки параметров AutoBudgetROILevel, AutoBudgetReserveReturn, " +
        "AutoBudgetProfitability при стратегии AutobudgetCrr")
@Stories(StoriesNames.CAMPAIGN_PARAMS_STRATEGY)
@Features({FeatureNames.CAMPAIGNS})
@RunWith(Parameterized.class)
public class BsTransportOfAutobudgetCrrTest {

    private static final String login = Logins.LOGIN_TRANSPORT;
    private static final long WEEKLY_SPEND_LIMIT = Money.valueOf(5000).bidLong().longValue();
    private static final long GOAL_ID = MetrikaGoals.getGoalForLogin(login);

    public static PerformanceBannersRule bannersRule = new PerformanceBannersRule().withUlogin(login);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().as(Logins.LOGIN_SUPER).withRules(bannersRule);

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public int crr;

    @Parameterized.Parameter(value = 1)
    public Long payForConversion;

    private TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private int shard;

    @Parameterized.Parameters(name = "Crr = {0}, PayForConversion = {1}")
    public static Collection crrData() {
        Object[][] data = new Object[][]{
                {200, 1L},
                {200, 0L},
                {200, null},
                {123, 1L},
                {123, 0L},
                {123, null},
        };

        return Arrays.asList(data);
    }

    @Before
    public void init() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Test
    public void shouldTransportTextCampaign() {
        //prepare campaign
        long textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .addCampMetrikaGoals(textCampaignId, GOAL_ID, 100L, 100L);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(textCampaignId);

        TextCampaignStrategyMap strategy = new TextCampaignStrategyMap()
                .withSearch(new TextCampaignSearchStrategyMap()
                        .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_CRR)
                        .withAverageCrr(new StrategyAverageCrrMap()
                                .withCrr(crr)
                                .withWeeklySpendLimit(WEEKLY_SPEND_LIMIT)
                                .withGoalId(GOAL_ID)
                        )
                ).withNetwork(new TextCampaignNetworkStrategyMap().defaultServingOff());

        api.userSteps.campaignSteps()
                .campaignsUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(textCampaignId)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withBiddingStrategy(strategy)
                                )
                        )
                );

        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .setStrategyDataPayForConversion(textCampaignId, payForConversion);

        Long strategyId =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(textCampaignId).getStrategyId();
        if (strategyId != 0) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).strategiesSteps().setStrategyDataPayForConversion(strategyId, payForConversion);
        }

        //assert
        checkTransport(textCampaignId);
    }

    @Test
    public void shouldTransportDynamicCampaign() {
        //prepare campaign
        long dynamicCampaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .addCampMetrikaGoals(dynamicCampaignId, GOAL_ID, 100L, 100L);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(dynamicCampaignId);

        DynamicTextCampaignStrategyMap strategy = new DynamicTextCampaignStrategyMap()
                .withSearch(new DynamicTextCampaignSearchStrategyMap()
                        .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CRR)
                        .withAverageCrr(new StrategyAverageCrrMap()
                                .withCrr(crr)
                                .withWeeklySpendLimit(WEEKLY_SPEND_LIMIT)
                                .withGoalId(GOAL_ID)
                        )
                ).withNetwork(new DynamicTextCampaignNetworkStrategyMap().defaultServingOff());

        api.userSteps.campaignSteps()
                .campaignsUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(dynamicCampaignId)
                                .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                        .withBiddingStrategy(strategy)
                                )
                        )
                );


        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .setStrategyDataPayForConversion(dynamicCampaignId, payForConversion);

        Long strategyId =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(dynamicCampaignId).getStrategyId();
        if (strategyId != 0) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).strategiesSteps().setStrategyDataPayForConversion(strategyId, payForConversion);
        }

        //assert
        checkTransport(dynamicCampaignId);
    }

    @Test
    public void shouldTransportSmartCampaign() {
        //create campaign
        long smartCampaignId = bannersRule.getCampaignId();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .addCampMetrikaGoals(smartCampaignId, GOAL_ID, 100L, 100L);
        helpSteps.makePerformanceCampaignReadyForSendingToBS(bannersRule, shard);

        SmartCampaignStrategyMap strategy = new SmartCampaignStrategyMap()
                .withSearch(new SmartCampaignSearchStrategyMap()
                        .withBiddingStrategyType(SmartCampaignSearchStrategyTypeEnum.AVERAGE_CRR)
                        .withAverageCrr(new StrategyAverageCrrMap()
                                .withCrr(crr)
                                .withWeeklySpendLimit(WEEKLY_SPEND_LIMIT)
                                .withGoalId(GOAL_ID)
                        )
                ).withNetwork(new SmartCampaignNetworkStrategyMap().defaultServingOff());

        api.userSteps.campaignSteps()
                .campaignsUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(smartCampaignId)
                                .withSmartCampaign(new SmartCampaignUpdateItemMap()
                                        .withBiddingStrategy(strategy)
                                )
                        )
                );

        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .setStrategyDataPayForConversion(smartCampaignId, payForConversion);

        Long strategyId =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(smartCampaignId).getStrategyId();
        if (strategyId != 0) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).strategiesSteps().setStrategyDataPayForConversion(strategyId, payForConversion);
        }

        //assert
        checkTransport(smartCampaignId);
    }

    private void checkTransport(long cid) {
        Campaign expectedCampaign = new Campaign();
        expectedCampaign.setAutoBudgetROILevel(crr / 100.0F);
        expectedCampaign.setAutoBudgetReserveReturn(1F);
        expectedCampaign.setAutoBudgetProfitability(1F);
        if (payForConversion != null && payForConversion > 0) {
            expectedCampaign.setAutobudgetPaidActions(1);
            expectedCampaign.setAutoBudgetPaidCrr(1);
        }
        //run transport
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .getClientDataRequestCampaign(resp, cid);

        //assert data
        assertThat(
                "Отправленные данные в БК совпадают с ожидаемыми",
                campaign,
                beanDiffer(expectedCampaign)
                        .useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()
                                .forFields(newPath("ndsHistory"), newPath("discountHistory"))
                                .useDiffer(new AlwaysOkDiffer())
                        )
        );
    }

}
