package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.strategy.search;

import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.data.commons.CampaignStrategy;
import ru.yandex.autotests.direct.cmd.data.counters.MetrikaCountersData;
import ru.yandex.autotests.direct.cmd.data.savecamp.SaveCampRequest;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.PerformanceBannersRule;
import ru.yandex.autotests.direct.cmd.util.CmdStrategyBeans;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.direct.utils.strategy.data.Strategies;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Filter;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by n-boy on 16.11.16.
 * https://st.yandex-team.ru/TESTIRT-10585
 */

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-60475")
@Title("Транспорт: проверка отправки/неотправки параметров AutoBudgetAvgBid, AutoBudgetAvgCPA на уровне кампании, " +
        "AutoBudgetPriority на уровне фильтров для performance кампании")
@Stories(StoriesNames.CAMPAIGN_PARAMS_STRATEGY)
@Features({FeatureNames.CAMPAIGNS, ApiFeatures.NOT_REGRESSION_YET})

public class BsTransportOfAutobudgetROIForPerformanceCampTest {

    private static final Double ROI_COEF = 10d;

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Campaign campaign;
    private static Filter filter;
    private static CampaignStrategy strategy;
    static {
        strategy = CmdStrategyBeans.getStrategyBean(Strategies.ROI_OPTIMIZATION_DMO);
        strategy.getNet().setGoalId(MetrikaCountersData.DEFAULT_COUNTER.getFirstGoalId().toString());
    }

    @ClassRule
    public static PerformanceBannersRule bannersRule =
            new PerformanceBannersRule().withMediaType(CampaignTypeEnum.DMO)
                    .overrideCampTemplate(new SaveCampRequest()
                            .withJsonStrategy(strategy))
                    .withUlogin(login);

    @ClassRule
    public static DirectCmdRule cmdRule = DirectCmdRule.defaultRule().as(Logins.LOGIN_SUPER).withRules(bannersRule);

    @BeforeClass
    public static void prepareCampAndSendToBS() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(login);


        helpSteps.makePerformanceCampaignReadyForSendingToBS(bannersRule, shard);
        Long filterId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bidsPerformanceSteps()
                .getBidsPerformanceByPid(bannersRule.getGroupId())
                .get(0).getPerfFilterId();

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, bannersRule.getCampaignId());
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, bannersRule.getCampaignId());
        Context context = campaign != null ? campaign.getContext(bannersRule.getGroupId()) : null;
        filter = context != null ? context.getFilter(filterId.intValue()) : null;
        assumeThat("в БК отправлен фильтр на уровне CONTEXT",
                filter, notNullValue());
    }

    @Test
    @Title("Неотправка параметра AutoBudgetAvgBid для стратегии на поиске AverageROI в performance кампании")
    public void testTransportOfAutoBudgetAvgBidForAutobudgetROIStrategyAtPerformance() {
        assertThat("параметр AutoBudgetAvgBid ожидаемо не отправлен в БК",
                campaign.getAutoBudgetAvgBid(), nullValue());
    }

    @Test
    @Title("Неотправка параметра AutoBudgetAvgCPA для стратегии на поиске AverageROI в performance кампании")
    public void testTransportOfAutoBudgetAvgCPAForAutobudgetROIStrategyAtPerformance() {
        assertThat("параметр AutoBudgetAvgCPA ожидаемо не отправлен в БК",
                campaign.getAutoBudgetAvgCPA(), nullValue());
    }

    @Test
    @Title("Отправка параметра AutoBudgetPriority на уровне фильтров для стратегии на поиске AverageROI в performance кампании")
    public void testTransportOfAutoBudgetPriorityForAutobudgetROIStrategyAtPerformance() {
        assertThat("отправленный в БК параметр AutoBudgetPriority в фильтре соответствует ожидаемому",
                filter.getAutoBudgetPriority(), greaterThan(0));
    }
}