package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.strategy.search;

import com.yandex.direct.api.v5.campaigns.MobileAppCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStrategyName;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.StrategiesType;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpiMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyPayForConversionMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки параметра AutoBudgetPaidActions " +
        "для стратегий на поиске AverageCPAOptimization и AverageCPIOOptimization")
@Stories(StoriesNames.CAMPAIGN_PARAMS_STRATEGY)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfPaidActionsForAvgCPAOptimizationStrategyTest {
    private static final Currency currency = Currency.RUB;
    private static final Money WEEKLY_BUDGET = MoneyCurrency.get(currency).getMinWeeklyBudgetAmount().addVAT();
    private static final Money AVERAGE_CPI = MoneyCurrency.get(currency)
            .getMinAverageConversionPrice().multiply(2L).addVAT();
    private static final Money BID_CEILING = MoneyCurrency.get(currency)
            .getMinAverageConversionPrice().multiply(3L);
    private static final Money CPA = MoneyCurrency.get(currency).getMinAveragePrice();

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    @Title("Отправка параметра AutoBudgetPaidActions для стратегии на поиске AverageCPAOptimization")
    public void testTransportOfAvgCPAForAvgCPAOptimizationStrategy() {
        int goalId = MetrikaGoals.getGoalForLogin(login).intValue();
        int shard = api.userSteps.clientFakeSteps().getUserShard(login);

        TextCampaignSearchStrategyMap searchStrategy =
                new TextCampaignSearchStrategyMap()
                        .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.PAY_FOR_CONVERSION)
                        .withPayForConversion(new StrategyPayForConversionMap()
                                .withWeeklySpendLimit(Money.valueOf(10000).bidLong().longValue())
                                .withGoalId((long) goalId)
                                .withCpa(CPA.bidLong().longValue()));
        TextCampaignNetworkStrategyMap networkStrategy =
                new TextCampaignNetworkStrategyMap().defaultNetworkDefault();

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .addCampMetrikaGoals(cid, (long) goalId, 100L, 100L);
        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap()
                .withCampaigns(new CampaignUpdateItemMap()
                        .withId(cid)
                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyMap()
                                        .withSearch(searchStrategy)
                                        .withNetwork(networkStrategy)))));
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp,
                cid);

        assertThat("отправленный в БК параметр AutoBudgetPaidActions соответствует ожиданиям",
                campaign.getAutobudgetPaidActions(), equalTo(1));
    }

    @Test
    @Title("Отправка параметра AutoBudgetPaidActions для стратегии на поиске AverageCPIOptimization")
    public void testTransportOfAvgCPIOptimizationStrategy() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(login);

        MobileAppCampaignSearchStrategyMap searchStrategy =
                new MobileAppCampaignSearchStrategyMap().defaultServingOff();
        MobileAppCampaignNetworkStrategyMap networkStrategy =
                new MobileAppCampaignNetworkStrategyMap()
                        .withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.AVERAGE_CPI)
                        .withAverageCpi(new StrategyAverageCpiMap()
                                .defaultStrategyAverageCpi(Currency.RUB)
                                .withWeeklySpendLimit(WEEKLY_BUDGET.subtractVAT().bidLong().longValue())
                                .withBidCeiling(BID_CEILING.bidLong().longValue())
                                .withAverageCpi(AVERAGE_CPI.subtractVAT().bidLong().longValue()));

        Long cid = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        api.userSteps.campaignSteps().campaignsUpdate(
                new UpdateRequestMap().withCampaigns(
                        new CampaignUpdateItemMap().withId(cid).withMobileAppCampaign(
                                new MobileAppCampaignUpdateItemMap().withBiddingStrategy(
                                        new MobileAppCampaignStrategyMap().withSearch(searchStrategy)
                                                .withNetwork(networkStrategy)
                                )
                        )
                )
        );

        Long pid = api.userSteps.adGroupsSteps().addDefaultMobileGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultMobileAppAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().setStrategyDataPayForConversion(cid, 1L);

        Long strategyId =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cid).getStrategyId();
        if (strategyId != 0) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).strategiesSteps().setStrategyDataPayForConversion(strategyId, 1L);
        }

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assertThat("отправленный в БК параметр AutoBudgetPaidActions соответствует ожиданиям",
                campaign.getAutobudgetPaidActions(), equalTo(1));
    }

    @Test
    @Title("Отправка параметра AutoBudgetPaidActionsPerFilter для стратегии autobudget_avg_cpa_per_filter" +
            " при оплате за конверсии")
    public void testTransportOfAvgCPAPerFilterStrategy() {
        int goalId = MetrikaGoals.getGoalForLogin(login).intValue();
        int shard = api.userSteps.clientFakeSteps().getUserShard(login);

        // На самом деле эта стратегия актуальна для смартовых кампаний, а не для текстовых
        // Но, к сожалению, пока у нас не хватает степов для заведения смартовых кампаний и групп
        // Поэтому в контексте этого теста воспользуемся текстовой кампанией (транспорту в этом месте без разницы)
        // Степы же нужно дописать, т.к. это как минимум позволит дописывать тесты на API
        TextCampaignSearchStrategyMap searchStrategy =
                new TextCampaignSearchStrategyMap()
                        .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.PAY_FOR_CONVERSION)
                        .withPayForConversion(new StrategyPayForConversionMap()
                                .withWeeklySpendLimit(Money.valueOf(10000).bidLong().longValue())
                                .withGoalId((long) goalId)
                                .withCpa(CPA.bidLong().longValue()));
        TextCampaignNetworkStrategyMap networkStrategy =
                new TextCampaignNetworkStrategyMap().defaultNetworkDefault();

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .addCampMetrikaGoals(cid, (long) goalId, 100L, 100L);
        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap()
                .withCampaigns(new CampaignUpdateItemMap()
                        .withId(cid)
                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyMap()
                                        .withSearch(searchStrategy)
                                        .withNetwork(networkStrategy)))));

        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        // В API пока нет возможности установить стратегию autobudget_avg_cpa_per_filter
        // Поэтому запишем в базу строчку руками
        // После добавления в API нужно будет убрать этот workaround
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().setStrategyData(
                cid,
                CampaignsStrategyName.autobudget_avg_cpa_per_filter,
                String.format("{\"name\": \"autobudget_avg_cpa_per_filter\", \"goal_id\": %d, \"version\": 1, " +
                        "\"filter_avg_cpa\": 100, \"pay_for_conversion\": 1, \"last_bidder_restart_time\": " +
                        "\"2021-02-26 15:26:18\"}", goalId));
        Long strategyId =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cid).getStrategyId();
        if (strategyId != 0) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).strategiesSteps().setStrategyData(
                    strategyId,
                    StrategiesType.autobudget_avg_cpa_per_filter,
                    String.format("{\"name\": \"autobudget_avg_cpa_per_filter\", \"goal_id\": %d, \"version\": 1, " +
                            "\"filter_avg_cpa\": 100, \"pay_for_conversion\": 1, \"last_bidder_restart_time\": " +
                            "\"2021-02-26 15:26:18\"}", goalId));
        }

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp,
                cid);

        assertThat("отправленный в БК параметр AutoBudgetAvgCPACur соответствует ожиданиям",
                campaign.getAutoBudgetAvgCPACur(), equalTo(120.0f));
        assertThat("отправленный в БК параметр AutoBudgetAvgCPA соответствует ожиданиям",
                campaign.getAutoBudgetAvgCPA(), equalTo(4.0f));
        assertThat("отправленный в БК параметр AutoBudgetPaidActions соответствует ожиданиям",
                campaign.getAutobudgetPaidActions(), equalTo(1));
        assertThat("отправленный в БК параметр AutoBudgetPaidActionsPerFilter соответствует ожиданиям",
                campaign.getAutoBudgetPaidActionsPerFilter(), equalTo(1));
    }
}
