package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.strategy.search;

import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpcAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.strategy.common.BsTransportOfWeekLimitForAverageClickPriceStrategy;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки параметров AutoBudgetWeekLimit и AutoBudgetWeekLimitCur " +
        "для стратегии на поиске AverageClickPrice")
@Stories(StoriesNames.CAMPAIGN_PARAMS_STRATEGY)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportOfWeekLimitForAverageClickPriceStrategyTest extends BsTransportOfWeekLimitForAverageClickPriceStrategy {
    @Before
    @Override
    public void before() {
        searchStrategy =
                new TextCampaignSearchStrategyAddMap().withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_CPC)
                        .withAverageCpc(new StrategyAverageCpcAddMap()
                                .withAverageCpc(Money.valueOf(AVERAGE_CLICK_PRICE).bidLong().longValue())
                                .withWeeklySpendLimit((weeklyBudget == null) ? null :
                                        weeklyBudget.bidLong().longValue()));
        networkStrategy =
                new TextCampaignNetworkStrategyAddMap().defaultNetworkDefault();
    }

    @Test
    @Title("Отправка параметра AutoBudgetWeekLimitCur для стратегии на поиске AverageClickPrice")
    public void testTransportOfWeekLimitCurForAverageClickPriceStrategy() {
        testTransportOfWeekLimitForAverageClickPriceStrategyCommon();
    }
}
