package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.timetarget;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingOnPublicHolidaysMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки поля AutoBudgetDayWeight")
@Stories(StoriesNames.CAMPAIGN_PARAMS_TIMETARGET)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportAutoBudgetDayWeightTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final String[] SCHEDULE = new String[]{
            "1,0,0,0,0,0,0,0,0,0,100,100,100,100,100,100,100,100,100,0,0,0,0,0,0",
            "2,0,0,0,0,0,0,0,0,0,100,100,100,100,100,100,100,100,100,0,0,0,0,0,0",
            "3,0,0,0,0,0,0,0,0,0,100,100,100,100,100,100,100,100,100,0,0,0,0,0,0",
            "4,0,0,0,0,0,0,0,0,0,100,100,100,100,100,100,100,100,100,0,0,0,0,0,0",
            "5,0,0,0,0,0,0,0,0,0,100,100,100,100,100,100,100,100,100,0,0,0,0,0,0",
            "6,0,0,0,0,0,0,0,0,0,100,100,100,100,100,100,100,100,100,0,0,0,0,0,0"};

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static int shard;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Test
    @Title("Отправка в БК кампании с временным таргетингом")
    public void testAutoBudgetDayWeightWithTimeTargeting() {
        TimeTargetingAddMap timeTargetingAddMap = getTimeTargeting();
        TextCampaignStrategyAddMap strategyAddMap = getStrategy();
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTimeTargeting(timeTargetingAddMap)
                .withTextCampaign(new TextCampaignAddItemMap().withBiddingStrategy(strategyAddMap)));
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp,
                cid);
        assertThat("в отправленной кампании присутствует AutoBudgetDayWeight", campaign.getAutoBudgetDayWeight(),
                notNullValue());

    }

    private static TimeTargetingAddMap getTimeTargeting() {
        return new TimeTargetingAddMap()
                .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                        .withSuspendOnHolidays(YesNoEnum.NO)
                        .withStartHour(1)
                        .withEndHour(10)
                        .withBidPercent(100))
                .withConsiderWorkingWeekends(YesNoEnum.NO)
                .withSchedule(SCHEDULE);
    }

    @Test
    @Title("Отправка в БК кампании без временного таргетинга")
    public void testAutoBudgetDayWeightWithEmptyTimeTargeting() {
        TextCampaignStrategyAddMap strategyAddMap = getStrategy();
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap().withBiddingStrategy(strategyAddMap)));

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp,
                cid);
        assertThat("в отправленной кампании присутствует AutoBudgetDayWeight", campaign.getAutoBudgetDayWeight(),
                notNullValue());
    }

    private static TextCampaignStrategyAddMap getStrategy() {
        TextCampaignNetworkStrategyAddMap strategyNetworkMap =
                new TextCampaignNetworkStrategyAddMap().defaultAverageCpa(Currency.RUB, 11732411L);
        return new TextCampaignStrategyAddMap()
                .withSearch(new TextCampaignSearchStrategyAddMap().defaultServingOff())
                .withNetwork(strategyNetworkMap);
    }

}
