package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.timetarget;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.TimeTargetingAdd;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingOnPublicHolidaysMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.matchers.timetarget.TimeTargetCoeffUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка коэффициентов ставок по времени - " +
        "TimeTargetCoeff - показы по праздникам выключены")
@Stories(StoriesNames.CAMPAIGN_PARAMS_TIMETARGET)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportOfTargetTimeCoeffWithDisabledHolidaysTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    @Parameterized.Parameter
    public String[] schedule;

    @Parameterized.Parameters(name = "Временной таргетинг = {0}")
    public static Collection<Object[]> data() {

        String[] scheduleFull = new String[]{
                "1,10,20,30,40,50,100,90,80,70,60,110,120,130,140,150,200,190,180,170,160,10,20,30,200",
                "2,10,20,30,40,50,100,90,80,70,60,110,120,130,140,150,200,190,180,170,160,10,20,30,200",
                "3,10,20,30,40,50,100,90,80,70,60,110,120,130,140,150,200,190,180,170,160,10,20,30,200",
                "4,10,20,30,40,50,100,90,80,70,60,110,120,130,140,150,200,190,180,170,160,10,20,30,200",
                "5,10,20,30,40,50,100,90,80,70,60,110,120,130,140,150,200,190,180,170,160,10,20,30,200",
                "6,10,20,30,40,50,100,90,80,70,60,110,120,130,140,150,200,190,180,170,160,10,20,30,200",
                "7,10,20,30,40,50,100,90,80,70,60,110,120,130,140,150,200,190,180,170,160,10,20,30,200"};

        String[] scheduleForBegins = new String[]{
                "1,10,20,30,40,50,200,190,180,170,160,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
                "2,10,20,30,40,50,200,190,180,170,160,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
                "3,10,20,30,40,50,200,190,180,170,160,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
                "4,10,20,30,40,50,200,190,180,170,160,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
                "5,10,20,30,40,50,200,190,180,170,160,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
                "6,10,20,30,40,50,200,190,180,170,160,100,100,100,100,100,100,100,100,100,100,100,100,100,100"};

        String[] scheduleForEnds = new String[]{
                "3,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,10,20,30,40,90,80,70,60,50",
                "4,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,10,20,30,40,90,80,70,60,50",
                "5,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,10,20,30,40,90,80,70,60,50",
                "6,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,10,20,30,40,90,80,70,60,50"};


        String[] scheduleWithHoles = new String[]{
                "1,100,100,100,100,100,100,100,100,100,10,20,30,40,100,50,60,70,160,170,180,190,200,150,100",
                "2,100,100,100,100,100,100,100,100,100,10,20,30,40,100,50,60,70,160,170,180,190,200,150,100",
                "3,100,100,100,100,100,100,100,100,100,10,20,30,40,100,50,60,70,160,170,180,190,200,150,100",
                "4,100,100,100,100,100,100,100,100,100,10,20,30,40,100,50,60,70,160,170,180,190,200,150,100",
                "6,10,20,30,50,100,100,100,100,100,100,100,10,20,30,50,20,30,40,90,80,70,60,50,100",
                "7,10,20,30,50,100,100,100,100,100,100,100,10,20,30,50,20,30,40,90,80,70,60,50,100"};

        Object[][] data = new Object[][]{
                {scheduleFull},
                {scheduleForBegins},
                {scheduleForEnds},
                {scheduleWithHoles},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Test
    @Title("Отправка в БК коэффициентов ставок по времени - TimeTargetCoeff - показы по праздникам выключены")
    public void testTimeTargetCoeffForDisabledHolidays() {
        TimeTargetingAddMap timeTargetingAddMap = new TimeTargetingAddMap()
                .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                        .withSuspendOnHolidays(YesNoEnum.YES))
                .withConsiderWorkingWeekends(YesNoEnum.NO)
                .withSchedule(schedule);
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTimeTargeting(timeTargetingAddMap)
                .withDefaultTextCampaign());
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("в отправленной кампании присутствует ShowCondition", campaign.getShowCondition(), notNullValue());

        String actualTimeTargetCoeff = campaign.getTimeTargetCoef();
        assertThat("отправленное в БК поле TimeTargetCoeff соответствует ожидаемому",
                actualTimeTargetCoeff,
                equalTo(TimeTargetCoeffUtils.timeTargetingAddToBidCoeff((TimeTargetingAdd) timeTargetingAddMap.getBean())));
    }
}
