package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.timetarget;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.TimeZoneCountryEnum;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-10067
 */
@Aqua.Test
@Title("Транспорт: проверка отправки временной зоны и страны")
@Stories(StoriesNames.CAMPAIGN_PARAMS_TIMETARGET)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-55816")
@RunWith(Parameterized.class)
public class BsTransportOfTimeZoneAndCountryIdTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static int shard;

    @Parameterized.Parameter(0)
    public TimeZoneCountryEnum timeZone;

    public Campaign campaign;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {TimeZoneCountryEnum.EUROPE_MOSCOW_RUSSIA},
                {TimeZoneCountryEnum.EUROPE_MOSCOW_OSETIA},
                {TimeZoneCountryEnum.EUROPE_KIEV_MOLDOVA},
                {TimeZoneCountryEnum.EUROPE_KIEV_UKRAINE},
                {TimeZoneCountryEnum.ASIA_ALMATY},
                {TimeZoneCountryEnum.EUROPE_MINSK},
                {TimeZoneCountryEnum.AFRICA_BRAZZAVILLE},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .updateCampaigns(
                        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                                .campaignsSteps().getCampaignById(cid).setTimezoneId(timeZone.getTimezoneId()
                        ));
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправилась в БК", campaign, notNullValue());
    }

    @Test
    @Title("Отправка в БК временной зоны")
    public void testTargetTimeTimeZone() {
        assumeThat("в отправленной кампании присутствует ShowCondition", campaign.getShowCondition(), notNullValue());
        assertThat("отправленное в БК поле TimeZone соответствует ожидаемому",
                campaign.getShowCondition().getTimeZone(), equalTo(timeZone.getTimeZone()));
    }

    @Test
    @Title("Отправка в БК страны")
    public void testCountryRegionId() {
        assertThat("отправленное в БК поле CountryRegionId соответствует ожидаемому",
                campaign.getCountryRegionId(), equalTo(timeZone.getCountryId()));
    }

}
