package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.timetarget;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingOnPublicHolidaysMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки настройки [учитывать рабочие выходные]")
@Stories(StoriesNames.CAMPAIGN_PARAMS_TIMETARGET)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportOfWorkingHolidaysTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    @Parameterized.Parameter
    public YesNoEnum workingOnHolidays;

    @Parameterized.Parameters(name = "Учитывать рабочие выходные: {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{YesNoEnum.YES}, {YesNoEnum.NO}};
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Test
    @Title("Отправка в БК настройки [учитывать рабочие выходные]")
    public void testTargetTimeWorkingHolidays() {
        TimeTargetingAddMap timeTargetingAddMap = new TimeTargetingAddMap()
                .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                        .withSuspendOnHolidays(YesNoEnum.NO)
                        .withStartHour(9)
                        .withEndHour(18)
                        .withBidPercent(100))
                .withConsiderWorkingWeekends(workingOnHolidays)
                .withSchedule(
                        "1,0,0,0,0,0,0,0,0,0,100,100,100,100,100,100,100,100,100,0,0,0,0,0,0",
                        "2,0,0,0,0,0,0,0,0,0,100,100,100,100,100,100,100,100,100,0,0,0,0,0,0",
                        "3,0,0,0,0,0,0,0,0,0,100,100,100,100,100,100,100,100,100,0,0,0,0,0,0",
                        "4,0,0,0,0,0,0,0,0,0,100,100,100,100,100,100,100,100,100,0,0,0,0,0,0",
                        "5,0,0,0,0,0,0,0,0,0,100,100,100,100,100,100,100,100,100,0,0,0,0,0,0",
                        "6,0,0,0,0,0,0,0,0,0,100,100,100,100,100,100,100,100,100,0,0,0,0,0,0",
                        "7,0,0,0,0,0,0,0,0,0,0,0,0,100,100,100,100,100,100,0,0,0,0,0,0"
                );
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTimeTargeting(timeTargetingAddMap)
                .withDefaultTextCampaign());
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("в отправленной кампании присутствует ShowCondition", campaign.getShowCondition(), notNullValue());

        Integer actualTimeWorking = campaign.getShowCondition().getTargetTimeWorking();
        assertThat("отправленное в БК поле TimeWorking соответствует настройке workingOnHolidays",
                actualTimeWorking, equalTo(workingOnHolidaysToTargetTimeWorking(workingOnHolidays)));
    }

    private int workingOnHolidaysToTargetTimeWorking(YesNoEnum workingOnHolidays) {
        return workingOnHolidays.equals(YesNoEnum.NO) ? 0 : 1;
    }
}
