package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.trafaretpositionbidcorrections;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierToggleTypeEnum;
import com.yandex.direct.api.v5.general.SerpLayoutEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.TrafaretPositionBidCorrection;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SerpLayoutAdjustmentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign.TRAFARET_POSITION_BID_CORRECTION;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Title("Транспорт: проверка отправки параметра TrafaretPositionBidCorrections на уровне кампании")
@Stories(StoriesNames.CAMPAIGN_PARAMS_TRAFARET_POSITION)
@Features(FeatureNames.CAMPAIGNS)
@Issue("https://st.yandex-team.ru/DIRECT-152209")
public class BsTransportOfOrderTrafaretPositionBidCorrectionsTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final Integer FIRST_COEF = 150;
    private static final Integer SECOND_COEF = 1200;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private Long cid;
    private Long pid;
    private RunBsTransportScriptResponse resp;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void before() {
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
    }

    @Test
    @Title("Отправка в БК корректировки TrafaretPositionBidCorrections на уровне кампании, одна группа без " +
            "корректировок")
    public void testTransportOfOrderTrafaretPositionBidCorrectionsOneGroupNoCoef() {
        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Map<String, Map> orderMap = helpSteps.getOrderMap(resp, cid);
        assumeThat("в БК отправлен заказ (кампания)", orderMap, notNullValue());
        assertThat("в БК не отправлена корректировка TrafaretPositionBidCorrections",
                orderMap.containsKey(TRAFARET_POSITION_BID_CORRECTION), equalTo(false));
    }

    @Test
    @Title("Отправка в БК корректировки TrafaretPositionBidCorrections на уровне кампании, одиночная корректировка")
    public void testTransportOfOrderTrafaretPositionBidCorrectionsOneGroupSingleCoef() {
        api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withCampaignId(cid)
                        .withSerpLayoutAdjustment(new SerpLayoutAdjustmentMap()
                                .withSerpLayout(SerpLayoutEnum.ALONE)
                                .withBidModifier(FIRST_COEF)
                        )
        );

        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Map<String, Double> expected = new HashMap<>();
        expected.put(TrafaretPositionBidCorrection.ALONE.toString(),
                BigDecimal.valueOf(FIRST_COEF).divide(BigDecimal.valueOf(100), 2, BigDecimal.ROUND_CEILING).doubleValue());
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assertThat("отправленная в БК корректировка TrafaretPositionBidCorrections на уровне кампании соответствует " +
                        "ожидаемой",
                campaign.getTrafaretPositionBidCorrections(), beanDiffer(expected));
    }

    @Test
    @Title("Отправка в БК корректировки TrafaretPositionBidCorrections на уровне кампании, двойная корректировка")
    public void testTransportOfOrderTrafaretPositionBidCorrectionsOneGroupMutlyCoef() {
        api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withCampaignId(cid)
                        .withSerpLayoutAdjustment(new SerpLayoutAdjustmentMap()
                                        .withSerpLayout(SerpLayoutEnum.ALONE)
                                        .withBidModifier(FIRST_COEF),
                                new SerpLayoutAdjustmentMap()
                                        .withSerpLayout(SerpLayoutEnum.SUGGEST)
                                        .withBidModifier(SECOND_COEF)
                        )
        );

        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Map<String, Double> expected = new HashMap<>();
        expected.put(TrafaretPositionBidCorrection.ALONE.toString(),
                BigDecimal.valueOf(FIRST_COEF).divide(BigDecimal.valueOf(100), 2, BigDecimal.ROUND_CEILING).doubleValue());
        expected.put(TrafaretPositionBidCorrection.SUGGEST.toString(),
                BigDecimal.valueOf(SECOND_COEF).divide(BigDecimal.valueOf(100), 2, BigDecimal.ROUND_CEILING).doubleValue());
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assertThat("отправленная в БК корректировка TrafaretPositionBidCorrections на уровне кампании соответствует " +
                        "ожидаемой",
                campaign.getTrafaretPositionBidCorrections(), beanDiffer(expected));
    }

    @Test
    @Title("Отправка в БК корректировки TrafaretPositionBidCorrections на уровне кампании, отключенная корректировка")
    public void testTransportOfOrderTrafaretPositionBidCorrectionsOneGroupDisabledSingleCoef() {
        Long bmId = api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withCampaignId(cid)
                        .withSerpLayoutAdjustment(new SerpLayoutAdjustmentMap()
                                .withSerpLayout(SerpLayoutEnum.ALONE)
                                .withBidModifier(FIRST_COEF)
                        )
        ).get(0);
        api.userSteps.bidModifiersSteps()
                .toggleBidModifiersCampaign(cid, BidModifierToggleTypeEnum.SERP_LAYOUT_ADJUSTMENT, YesNoEnum.NO);

        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Map<String, Map> orderMap = helpSteps.getOrderMap(resp, cid);
        assumeThat("в БК отправлен заказ (кампания)", orderMap, notNullValue());
        assertThat("в БК не отправлена корректировка TrafaretPositionBidCorrections",
                orderMap.containsKey(TRAFARET_POSITION_BID_CORRECTION), equalTo(false));
    }
}
