package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.type;
import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsSource;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 15/12/15.
 * https://st.yandex-team.ru/TESTIRT-8040
 */
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-49479")
@Title("Транспорт: Поле ContentType")
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportOfDirectCampaignTypeTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final String ASSERT_MESSAGE = "при отправке кампании отправляется правильное значение ContentType";

    @ClassRule
    public static final ApiSteps API = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(API);

    @Parameterized.Parameter
    public CampaignsType campaignsType;

    @Parameterized.Parameter(1)
    public CampaignsSource source;

    @Parameterized.Parameter(2)
    public String contentTypeForSource;

    @Parameterized.Parameters(name = "тип кампании — {0}, source — {1}, contentType — {2}")
    public static Collection<Object> testData() {
        Object[][] data = new Object[][]{
                {CampaignsType.TEXT, null, null},
                {CampaignsType.TEXT, CampaignsSource.zen, "zen"},
                {CampaignsType.PERFORMANCE, null, null},
                {CampaignsType.DYNAMIC, null, null},
                {CampaignsType.MOBILE_CONTENT, null, null},
                {CampaignsType.MCBANNER, null, null},
                {CampaignsType.WALLET, null, null},
                {CampaignsType.CPM_BANNER, null, null},
                {CampaignsType.CPM_DEALS, null, null}
        };
        return Arrays.asList(data);
    }

    private static int shard;
    private static Long cid;

    @BeforeClass
    public static void beforeClass() {
        shard = API.userSteps.clientFakeSteps().getUserShard(LOGIN);
        cid = API.userSteps.campaignSteps().addDefaultTextCampaign();
        API.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
    }

    @Before
    public void init() {
        API.userSteps.campaignFakeSteps().setType(cid, campaignsType);
        API.userSteps.campaignFakeSteps().setBSSynced(cid.intValue(), false);
        if (source != null) {
            API.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().setSource(cid, source);
        } else {
            API.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().setSource(cid, CampaignsSource.api);
        }
    }

    @Test
    public void testTransportOfDirectCampaignTypeTest() {
        RunBsTransportScriptResponse resp = API.userSteps.getDarkSideSteps().getTransportSteps()
                .sendSyncedCampaign(shard, cid);
        Campaign campaign = API.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());
        if (contentTypeForSource == null) {
            assertThat(ASSERT_MESSAGE,
                    campaign.getContentType(), equalTo(campaignsType.contentType()));
        } else {
            assertThat(ASSERT_MESSAGE,
                    campaign.getContentType(), equalTo(contentTypeForSource));
        }
    }
}
