package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.type;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 15/12/15.
 * https://st.yandex-team.ru/TESTIRT-8040
 * 1 - обычные кампании
 * 7 - геоконтекст
 * 6 - если оплачено сертификатом
 * 8 - если это камания бегуна или с номером 2834265
 * 9 - кампании БЮ
 */
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-49479")
@Title("Транспорт: Поле OrderType")
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportOfOrderTypeTest {

    private static final String LOGIN = Logins.BUSINESS_UNIT1;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public CampaignsType campaignsType;

    @Parameterized.Parameter(1)
    public int isBU;

    @Parameterized.Parameter(2)
    public int expectedOrderType;

    @Parameterized.Parameters(name = "тип кампании - {0}, is_business_unit - {1}, отправляемый OrderType - {2}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {CampaignsType.TEXT, 1, 9},
                {CampaignsType.PERFORMANCE, 1, 9},
                {CampaignsType.DYNAMIC, 1, 9},
                {CampaignsType.MOBILE_CONTENT, 1, 9},
                {CampaignsType.WALLET, 1, 9},
                {CampaignsType.MCBANNER, 1, 9},
                {CampaignsType.CPM_BANNER, 1, 9},
                {CampaignsType.CPM_DEALS, 1, 9},
                {CampaignsType.TEXT, 0, 1},
                {CampaignsType.PERFORMANCE, 0, 1},
                {CampaignsType.DYNAMIC, 0, 1},
                {CampaignsType.MOBILE_CONTENT, 0, 1},
                {CampaignsType.WALLET, 0, 1},
                {CampaignsType.MCBANNER, 0, 1},
                {CampaignsType.CPM_BANNER, 0, 1},
                {CampaignsType.CPM_DEALS, 0, 1},
        };
        return Arrays.asList(data);
    }

    private static int shard;
    private static Long clientId;
    private static Long cid;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        clientId = Long.valueOf(User.get(LOGIN).getClientID());
    }

    @Before
    public void init() {
        // В https://st.yandex-team.ru/DIRECT-152525 OrderType стал неизменяемым
        // Поэтому каждый тест нужно прогонять на новой кампании
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.campaignFakeSteps().setType(cid, campaignsType);
        api.userSteps.campaignFakeSteps().setBSSynced(cid.intValue(), false);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).clientsOptionsSteps()
                .setClientOptionsIsBusinessUnit(clientId, isBU);
    }

    @Test
    public void testTransportOfDirectCampaignTypeTest() {
        RunBsTransportScriptResponse resp = api.userSteps
                .getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps()
                .getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());
        assertThat("при отправке кампании  отправляется правильное значение OrderType"
                , campaign.getOrderType(), equalTo(expectedOrderType));
    }
}
