package ru.yandex.autotests.directintapi.bstransport.main.campsonly.queue;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BsExportSpecialsParType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsExportQueueRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.steps.ScriptParamsProfiles;
import ru.yandex.autotests.directapi.darkside.steps.TransportSteps;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.matchers.QueueRecordMatcher;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.core.IsNull.notNullValue;
import static org.hamcrest.core.IsNull.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Проверка отправки кампании с баннерами воркером camps_only, неудаление из очереди, удаление из спец. очереди")
@Stories(StoriesNames.CAMPS_ONLY_QUEUE_STATUS)
@Features({FeatureNames.CAMPS_ONLY, FeatureNames.NOT_FOR_FULL_EXPORT})
public class CampsOnlyBsQueueCampWithBanners {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long cid;
    private static Long pid;
    private static Long bid;
    private static DirectJooqDbSteps jooqDbSteps;

    @BeforeClass
    public static void beforeClass() {

        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        jooqDbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps(shard);
        TransportSteps transportSteps = api.userSteps.getDarkSideSteps().getTransportSteps();
        transportSteps.sendNewCampaign(shard, cid);

        jooqDbSteps.transportSteps().putCampInBsExportSpecials(cid, BsExportSpecialsParType.camps_only);
        jooqDbSteps.campaignsSteps().setCampaignsStatusBsSynced(cid, CampaignsStatusbssynced.No);
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, Status.NO);
        api.userSteps.bannersFakeSteps().setStatusBsSynced(bid, Status.NO);
        api.userSteps.phrasesFakeSteps().setStatusBsSynced(keywordId, Status.NO);
        transportSteps.runBsExportMasterScript(shard, cid);
        BsExportQueueRecord originalCampaignInExportQueue = jooqDbSteps.transportSteps().getBsExportQueueRecord(cid);
        assumeThat("несинхронная кампания добавлена в очередь", originalCampaignInExportQueue, notNullValue());
        assumeThat("статистика в очереди соответствует ожидаемой",
                originalCampaignInExportQueue, new QueueRecordMatcher()
                        .withCamps()
                        .withContexts()
                        .withBanners()
                        .withBids());
        checkStatusbssynced(CampaignsStatusbssynced.Sending);
        transportSteps.sendSyncedCampaignWithProfile(shard, cid, ScriptParamsProfiles.ProfileNames.CAMPS_ONLY);
    }

    @Test
    @Title("Проверяем, что bsClientData не удалил кампанию из очереди, но сбросил camps_num")
    public void testCampNumResetInBsQueueStats() {
        BsExportQueueRecord updatedCampaignInExportQueue = jooqDbSteps.transportSteps().getBsExportQueueRecord(cid);
        assertThat("Кампания осталась в очереди, но camps_num сбросилось",
                updatedCampaignInExportQueue, new QueueRecordMatcher()
                        .withContexts()
                        .withBanners()
                        .withoutCamps()
                        .withBids());
        checkStatusbssynced(CampaignsStatusbssynced.Yes);
    }

    @Test
    @Title("Проверяем, что bsClientData удалил кампанию из спец. очереди")
    public void testCampRemovedFromCampsOnlySpecialQueue() {
        BsExportSpecialsParType parType = jooqDbSteps.transportSteps().getCampBsExportSpecialsParType(cid);
        assertThat("Кампания удалена из очереди после отправки", parType, nullValue());
    }

    private static void checkStatusbssynced(CampaignsStatusbssynced expectCampaignsStatusbssynced) {
        CampaignsRecord campaignsRecord = jooqDbSteps.campaignsSteps().getCampaignById(cid);
        Assert.assertThat("Кампания клиента не синхронизирована с БК",
                campaignsRecord.getStatusbssynced(), equalTo(expectCampaignsStatusbssynced));

        BannersRecord bannerRecord = jooqDbSteps.bannersSteps().getBanner(bid);
        Assert.assertThat("баннер не синхронизирован с БК",
                bannerRecord.getStatusbssynced(), equalTo(BannersStatusbssynced.Sending));

        PhrasesRecord phrasesRecord = jooqDbSteps.adGroupsSteps().getPhrases(pid);
        Assert.assertThat("Статус группы не синхронизирован с БК",
                phrasesRecord.getStatusbssynced(), equalTo(PhrasesStatusbssynced.Sending));
    }
}
