package ru.yandex.autotests.directintapi.bstransport.main.campsonly.queue;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsExportQueueRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.db.utils.JooqRecordDifferMatcher;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.steps.ScriptParamsProfiles;
import ru.yandex.autotests.directapi.darkside.steps.TransportSteps;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.matchers.QueueRecordMatcher;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.core.Is.is;
import static org.hamcrest.core.IsNull.notNullValue;
import static org.hamcrest.core.IsNull.nullValue;
import static ru.yandex.autotests.direct.db.utils.JooqRecordDifferMatcher.recordDiffer;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Проверка, что воркер camps_only не обрабатывает кампанию, если ее нет в спец. очереди")
@Stories(StoriesNames.CAMPS_ONLY_QUEUE_STATUS)
@Features({FeatureNames.CAMPS_ONLY, FeatureNames.NOT_FOR_FULL_EXPORT})
public class CampsOnlyIgnoresCampWithoutSpecialQueue {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long cid;
    private static RunBsTransportScriptResponse runBsTransportScriptResponse;
    private static DirectJooqDbSteps jooqDbSteps;
    private static BsExportQueueRecord updatedCampaignInExportQueue;

    @BeforeClass
    public static void beforeClass() {

        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        jooqDbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps(shard);
        TransportSteps transportSteps = api.userSteps.getDarkSideSteps().getTransportSteps();

        transportSteps.runBsExportMasterScript(shard, cid);
        updatedCampaignInExportQueue = jooqDbSteps.transportSteps().getBsExportQueueRecord(cid);
        assumeThat("несинхронная кампания добавлена в очередь", updatedCampaignInExportQueue, notNullValue());
        assumeThat("статистика в очереди соответствует ожидаемой",
                updatedCampaignInExportQueue, new QueueRecordMatcher()
                        .withCamps()
                        .withContexts()
                        .withBanners()
                        .withBids());

        CampaignsRecord campaignsRecord = jooqDbSteps.campaignsSteps().getCampaignById(cid);
        assumeThat("Кампания клиента не синхронизирована с БК",
                campaignsRecord.getStatusbssynced(), equalTo(CampaignsStatusbssynced.Sending));

        BannersRecord bannerRecord = jooqDbSteps.bannersSteps().getBanner(bid);
        assumeThat("баннер не синхронизирован с БК",
                bannerRecord.getStatusbssynced(), equalTo(BannersStatusbssynced.Sending));

        PhrasesRecord phrasesRecord = jooqDbSteps.adGroupsSteps().getPhrases(pid);
        assumeThat("Статус группы не синхронизирован с БК",
                phrasesRecord.getStatusbssynced(), equalTo(PhrasesStatusbssynced.Sending));

        runBsTransportScriptResponse =
                transportSteps.runBsClientDataScript(shard, cid, ScriptParamsProfiles.ProfileNames.CAMPS_ONLY);
    }

    @Test
    @Title("Проверяем, что bsClientData не отправил кампанию")
    public void testCampNotSent() {
        assertThat("кампания не отправлена", runBsTransportScriptResponse, nullValue());
    }

    @Test
    @Title("Проверяем, что bsClientData не модифицировал очередь")
    public void testQueueNotModified() {
        BsExportQueueRecord bsExportQueueRecord = jooqDbSteps.transportSteps().getBsExportQueueRecord(cid);
        JooqRecordDifferMatcher<BsExportQueueRecord> recordDifferMatcher = recordDiffer(bsExportQueueRecord);
        assertThat("матчер не обнаружит разницу",
                recordDifferMatcher
                        .useCompareStrategy(DefaultCompareStrategies.allFields())
                        .matches(updatedCampaignInExportQueue),
                is(true));
    }
}
