package ru.yandex.autotests.directintapi.bstransport.main.campsonly.transmit;

import java.util.Set;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BsExportSpecialsParType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusbssynced;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.CampaignFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.steps.ScriptParamsProfiles;
import ru.yandex.autotests.directapi.darkside.steps.TransportSteps;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.UPDATE_DATA)
@Title("Проверка отправки параметров кампании воркером camps_only")
@Stories(StoriesNames.CAMPS_ONLY_UPDATE_DATA)
@Features({FeatureNames.CAMPS_ONLY, FeatureNames.NOT_FOR_FULL_EXPORT})
public class CampsOnlyUpdateData {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static CampaignFakeInfo campaignFakeInfo;
    private static Campaign campaign;
    private static TransportHelpSteps helpSteps;
    private static Long cid;
    private static int shard;

    @BeforeClass
    public static void beforeClass() {

        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps(shard);
        TransportSteps transportSteps = api.userSteps.getDarkSideSteps().getTransportSteps();
        helpSteps = new TransportHelpSteps(api).useDbJooqSteps(jooqDbSteps);
        transportSteps.sendNewCampaign(shard, cid);

        jooqDbSteps.transportSteps().putCampInBsExportSpecials(cid, BsExportSpecialsParType.camps_only);
        jooqDbSteps.campaignsSteps().setCampaignsStatusBsSynced(cid, CampaignsStatusbssynced.No);
        api.userSteps.bannersFakeSteps().setStatusBsSynced(bid, Status.NO);
        RunBsTransportScriptResponse resp =
                transportSteps.sendSyncedCampaignWithProfile(shard, cid, ScriptParamsProfiles.ProfileNames.CAMPS_ONLY);
        campaign = transportSteps.getClientDataRequestCampaign(resp, 0, cid);
        assumeThat("Кампания отправлена", campaign, notNullValue());
        campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(cid);
    }

    @Test
    @Title("Проверяем отправку некоторых параметров кампании")
    public void testCampaignParams() {
        int groupOrderID = 0;
        if (campaignFakeInfo.getWalletIsEnabled() != 0) {
            groupOrderID = Integer.parseInt(
                    api.userSteps.campaignFakeSteps().fakeGetCampaignParams(campaignFakeInfo.getWalletCid())
                            .getOrderID());
        }

        Campaign expectedCampaign = helpSteps.buildExpectedCampaignObjFromDb(cid, shard, UpdateInfo.UPDATE);
        expectedCampaign.setSum(0.0);
        expectedCampaign.setSumCur(campaignFakeInfo.getSum().doubleValue());
        expectedCampaign.setGroupOrderID(groupOrderID);
        expectedCampaign.setGroupOrder(0);
        expectedCampaign.setAgencyId(0);
        expectedCampaign.setArchive(0);
        expectedCampaign.setStop(0);
        expectedCampaign.setClientID(api.userSteps.clientFakeSteps().getClientData(login).getClientID());

        assertThat("параметры кампании соответствует ожидаемой", campaign,
                beanDiffer(expectedCampaign).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }

    @Test
    @Title("Проверяем неотправку CONTEXT")
    public void testContextNotSent() {
        Set<String> sentContexts = campaign.getContexts().keySet();
        assertThat("CONTEXT не отправляется", sentContexts, empty());
    }
}
