package ru.yandex.autotests.directintapi.bstransport.main.canvasad.queue;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.CreativeBannerRule;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PerfCreativesStatusmoderate;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.displaycanvas.ModerationInfo;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.nullValue;
import static org.hamcrest.core.IsNull.notNullValue;
import static org.junit.Assume.assumeThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pashkus on 08.09.16.
 * https://st.yandex-team.ru/TESTIRT-10191
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Проверяем постановку в очередь в зависимости от статусов модерации")
@Description("")
@Stories(StoriesNames.CANVAS_AD_SENDING)
@Features({FeatureNames.CANVAS_IMAGE_ADS, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-57413")
@RunWith(Parameterized.class)
public class ModerationOfCanvasBannerTest {
    public static final String LOGIN = Logins.LOGIN_TRANSPORT_IMG_AD;

    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @ClassRule
    public static final DirectCmdRule defaultClassRule = DirectCmdRule.defaultClassRule();

    public final CreativeBannerRule bannersRule;


    @Rule
    public DirectCmdRule cmdRule;

    protected static int shard;
    protected Long cid;
    protected Long pid;
    protected Long bid;
    protected Long creativeId;
    protected Long keywordId;

    public final CampaignTypeEnum campaignType;

    public ModerationOfCanvasBannerTest(CampaignTypeEnum campaignType) {
        this.campaignType = campaignType;
        bannersRule = new CreativeBannerRule(campaignType).withUlogin(LOGIN);
        cmdRule = DirectCmdRule.defaultRule().withRules(bannersRule);
    }

    @Parameterized.Parameters(name = "Тип кампаниии: {0};")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {CampaignTypeEnum.TEXT},
                //    {CampaignTypeEnum.MOBILE},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка: создаем кампанию с креативным баннером.")
    public void basicInit() {
        api.as(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        cid = bannersRule.getCampaignId();
        creativeId = bannersRule.getCreativeId();
        bid = bannersRule.getBannerId();
        pid = bannersRule.getGroupId();
        assumeThat("у баннера есть хотя бы одна ключевая фраза",
                bannersRule.getCurrentGroup().getPhrases().size(),
                notNullValue());
        keywordId = bannersRule.getCurrentGroup().getPhrases().get(0).getId();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
    }

    @Test
    @Title("Постановка в очередь при модерации всех объектов")
    @Description("Проставляем статус модерации yes в campaigns, phrases, banners, banners_performance")
    public void testAllModerated() {
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        jooqDbSteps.bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bid, BannersPerformanceStatusmoderate.Yes);
        jooqDbSteps.perfCreativesSteps().setModerateInfo(creativeId,
                new ModerationInfo().generateTestData().asJson());
        jooqDbSteps.perfCreativesSteps().setStatusModerate(creativeId, PerfCreativesStatusmoderate.Yes);

        runAndCheck(true);
    }

    @Test
    @Title("Все объекты промодерированы, кроме perf_creatives")
    @Description("perf_creatives.statusModerate= No - не влияет на постановку в очередь")
    public void testAllModeratedExceptPerfCreatives() {
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        jooqDbSteps.bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bid, BannersPerformanceStatusmoderate.Yes);
        jooqDbSteps.perfCreativesSteps().setModerateInfo(creativeId,
                new ModerationInfo().generateTestData().asJson());
        jooqDbSteps.perfCreativesSteps().setStatusModerate(creativeId, PerfCreativesStatusmoderate.No);

        runAndCheck(true);
    }


    @Test
    @Title("Все объекты промодерированы, кроме perf_creatives")
    @Description("perf_creatives.statusModerate= No - не влияет на постановку в очередь")
    public void testGroupStatusModerateNo() {
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        jooqDbSteps.bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bid, BannersPerformanceStatusmoderate.Yes);
        jooqDbSteps.perfCreativesSteps().setModerateInfo(creativeId,
                new ModerationInfo().generateTestData().asJson());
        jooqDbSteps.perfCreativesSteps().setStatusModerate(creativeId, PerfCreativesStatusmoderate.No);

        runAndCheck(false);
    }

    private void runAndCheck(boolean expectContext) {
        api.userSteps.transportSteps().runBsExportMasterScript(shard, cid);
        RunBsTransportScriptResponse resp = api.userSteps.transportSteps().runBsClientDataScript(shard, cid);

        Map campaign = api.userSteps.transportSteps().getRawClientDataLogRequestForCampaign(resp, cid);
        Map context = api.userSteps.transportSteps().getRawClientDataLogRequestForContext(resp, cid, pid);
        Map banner = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(resp, cid, pid, bid);
        Map keyword = api.userSteps.transportSteps().getRawClientDataLogRequestForKeyword(resp, cid, pid);

        assertThat("Ожидаем, что в БК была отправлена новая кампания", campaign, notNullValue());
        if (expectContext) {
            assertThat("Ожидаем, что в БК была отправлена новая группа", context, notNullValue());
            assertThat("Ожидаем, что в БК был отправлен новый баннер", banner, notNullValue());
            assertThat("Ожидаем, что в БК была отправлена новая фраза", keyword, notNullValue());
        } else {
            assertThat("Ожидаем, что в БК не была отправлена новая группа", context, nullValue());
        }

    }
}
