package ru.yandex.autotests.directintapi.bstransport.main.canvasad.transmit;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ImagesStatusmoderate;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;


/**
 * Created by pashkus on 08.09.16.
 * https://st.yandex-team.ru/TESTIRT-10191
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Title("Создание в одной группе простого и canvas графических баннеров")
@Stories(StoriesNames.CANVAS_AD_SENDING)
@Features(FeatureNames.CANVAS_IMAGE_ADS)
@Issue("https://st.yandex-team.ru/DIRECT-57413")
@RunWith(Parameterized.class)
public class SendingOfCanvasAndImageBannerParamsTest extends SendingOfCanvasBannerBaseTest {

    public Long imageAd;

    @Parameterized.Parameters(name = "Тип кампаниии: {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {CampaignTypeEnum.TEXT, AdGroupType.BASE},
                {CampaignTypeEnum.MOBILE, AdGroupType.MOBILE_CONTENT}
        };
        return Arrays.asList(data);
    }

    public SendingOfCanvasAndImageBannerParamsTest(CampaignTypeEnum campaignTypeEnum, AdGroupType adGroupType) {
        super(campaignTypeEnum, adGroupType, BannerType.IMAGE_AD);
    }

    @Step("api: добавляем к группе графический баннер")
    void additionalInit() {
        log.info("additionalInit() started #pashkus");

        String imageHash = api.userSteps.imagesStepsV5().adImagesGetAllHashes(LOGIN).get(0);
        imageAd = api.userSteps.adsSteps().addAdWithAdImageHash(pid, adGroupType, bannerType, imageHash);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(imageAd);
        api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShard(shard).imagesSteps()
                .setImageStatusModerate(imageAd, imageHash, ImagesStatusmoderate.Yes);
    }

    @Test
    @Title("Проверяем, что баннер-креатив отправляется в БК")
    public void testCreativeAdSendingToBs() {
        Campaign campaign
                = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner creativeBanner = context != null ? context.getBanner(bid) : null;
        Banner imageBanner = context != null ? context.getBanner(imageAd) : null;

        assumeThat("ГО с креативом есть в запросе", creativeBanner, notNullValue());
        assumeThat("ГО есть в запросе", imageBanner, notNullValue());

        Banner expectedCanvasBanner = helpSteps.buildExpectedNewCanvasBannerFromDb(bid);
        assertThat("набор полей в ГО с креативом соответствует ожиданиям",
                creativeBanner,
                beanDiffer(expectedCanvasBanner).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));

        Banner expectedImageBanner = helpSteps.buildExpectedNewImageBannerFromDb(imageAd);
        expectedCanvasBanner.setMediaImage(helpSteps.getExpectedMediaImage(cid, pid, imageAd));
        assertThat("набор полей в ГО соответствует ожиданиям",
                imageBanner,
                beanDiffer(expectedImageBanner).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }

    @Test
    @Ignore
    @Title("Проверяем, что графический баннер отправляется в БК")
    public void testImageAdSendingToBs() {
        Campaign campaign
                = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner imageBanner = context != null ? context.getBanner(imageAd) : null;

        assertThat("в БК отправлен графический баннер", imageBanner, notNullValue());
    }


}
