package ru.yandex.autotests.directintapi.bstransport.main.canvasad.transmit;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.model.ImageType;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;


/**
 * Created by pashkus on 08.09.16.
 * https://st.yandex-team.ru/TESTIRT-10191
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Title("Создание в одной группе canvas баннера и текстового баннера с картинкой")
@Stories(StoriesNames.CANVAS_AD_SENDING)
@Features(FeatureNames.CANVAS_IMAGE_ADS)
@Issue("https://st.yandex-team.ru/DIRECT-57413")
@Ignore() //because of https://st.yandex-team.ru/DIRECT-58574
@RunWith(Parameterized.class)
public class SendingOfCanvasAndTextImageBannerParamsTest extends SendingOfCanvasBannerBaseTest {
    public Long picBid;
    public Long imageId;

    @Parameterized.Parameters(name = "Тип кампаниии: {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {CampaignTypeEnum.TEXT, AdGroupType.BASE, BannerType.TEXT},
                {CampaignTypeEnum.MOBILE, AdGroupType.MOBILE_CONTENT, BannerType.MOBILE_CONTENT}
        };
        return Arrays.asList(data);
    }

    public SendingOfCanvasAndTextImageBannerParamsTest(
            CampaignTypeEnum campaignTypeEnum, AdGroupType adGroupType, BannerType bannerType) {
        super(campaignTypeEnum, adGroupType, bannerType);
    }

    @Override
    public String getLogin() {
        return Logins.LOGIN_TRANSPORT_IMG_WIDE;
    }

    @Step("api: добавляем к группе текстовый баннер c картинкой")
    void additionalInit() {
        String[] imageHashes = helpSteps.addImagesForUserIfNotExists(LOGIN, ImageType.WIDE);

        picBid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withAdWithAdImageHash(adGroupType, bannerType, imageHashes[0]));
        imageId = api.userSteps.getDirectJooqDbSteps().useShard(shard).
                imagesSteps().getBannerImagesByBid(picBid).getImageId();

        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(picBid);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).imagesSteps()
                .setBannerImagesStatusModerate(imageId, BannerImagesStatusmoderate.Yes);
    }

    @Test
    @Title("Проверяем, что все 3 баннера отправились в БК")
    public void testSendingToBs() {
        Campaign campaign
                = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner creativeBanner = context != null ? context.getBanner(bid) : null;
        Banner textBanner = context != null ? context.getBanner(picBid) : null;
        Banner imgBanner = context != null ? context.getBanner(imageId) : null;

        assertThat("в БК отправлен графический баннер", creativeBanner, notNullValue());
        assertThat("в БК отправлен графический баннер", textBanner, notNullValue());
        assertThat("в БК отправлен графический баннер", imgBanner, notNullValue());

        assumeThat("ГО с креативом есть в запросе", creativeBanner, notNullValue());
        assumeThat("текстовый баннер есть в запросе", textBanner, notNullValue());

        Banner expectedCanvasBanner = helpSteps.buildExpectedCanvasBannerFromDb(bid);
        assertThat("набор полей в ГО с креативом соответствует ожиданиям",
                creativeBanner,
                beanDiffer(expectedCanvasBanner).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));

        Banner expectedTextBanner = helpSteps.buildExpectedNewCommonBannerFromDb(picBid);
        expectedTextBanner.setLang("en");
        assertThat("набор полей в текстовом баннере соответствует ожиданиям",
                textBanner,
                beanDiffer(expectedTextBanner).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }

}
